/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.BsonType;
import org.bson.BsonValue;

public final class BsonTimestamp
extends BsonValue
implements Comparable<BsonTimestamp> {
    private final long value;

    public BsonTimestamp() {
        this.value = 0L;
    }

    public BsonTimestamp(long l) {
        this.value = l;
    }

    public BsonTimestamp(int n, int n2) {
        this.value = (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.TIMESTAMP;
    }

    public long getValue() {
        return this.value;
    }

    public int getTime() {
        return (int)(this.value >> 32);
    }

    public int getInc() {
        return (int)this.value;
    }

    public String toString() {
        return "Timestamp{value=" + this.getValue() + ", seconds=" + this.getTime() + ", inc=" + this.getInc() + '}';
    }

    @Override
    public int compareTo(BsonTimestamp bsonTimestamp) {
        return Long.compareUnsigned(this.value, bsonTimestamp.value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BsonTimestamp bsonTimestamp = (BsonTimestamp)object;
        return this.value == bsonTimestamp.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }
}

