/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.ByteBuf;

public class ByteBufNIO
implements ByteBuf {
    private ByteBuffer buf;
    private final AtomicInteger referenceCount = new AtomicInteger(1);

    public ByteBufNIO(ByteBuffer byteBuffer) {
        this.buf = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    @Override
    public ByteBufNIO retain() {
        if (this.referenceCount.incrementAndGet() == 1) {
            this.referenceCount.decrementAndGet();
            throw new IllegalStateException("Attempted to increment the reference count when it is already 0");
        }
        return this;
    }

    @Override
    public void release() {
        if (this.referenceCount.decrementAndGet() < 0) {
            this.referenceCount.incrementAndGet();
            throw new IllegalStateException("Attempted to decrement the reference count below 0");
        }
        if (this.referenceCount.get() == 0) {
            this.buf = null;
        }
    }

    @Override
    public int capacity() {
        return this.buf.capacity();
    }

    @Override
    public ByteBuf put(int n, byte by) {
        this.buf.put(n, by);
        return this;
    }

    @Override
    public int remaining() {
        return this.buf.remaining();
    }

    @Override
    public ByteBuf put(byte[] byArray, int n, int n2) {
        this.buf.put(byArray, n, n2);
        return this;
    }

    @Override
    public boolean hasRemaining() {
        return this.buf.hasRemaining();
    }

    @Override
    public ByteBuf put(byte by) {
        this.buf.put(by);
        return this;
    }

    @Override
    public ByteBuf flip() {
        ((Buffer)this.buf).flip();
        return this;
    }

    @Override
    public byte[] array() {
        return this.buf.array();
    }

    @Override
    public int limit() {
        return this.buf.limit();
    }

    @Override
    public ByteBuf position(int n) {
        ((Buffer)this.buf).position(n);
        return this;
    }

    @Override
    public ByteBuf clear() {
        ((Buffer)this.buf).clear();
        return this;
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        this.buf.order(byteOrder);
        return this;
    }

    @Override
    public byte get() {
        return this.buf.get();
    }

    @Override
    public byte get(int n) {
        return this.buf.get(n);
    }

    @Override
    public ByteBuf get(byte[] byArray) {
        this.buf.get(byArray);
        return this;
    }

    @Override
    public ByteBuf get(int n, byte[] byArray) {
        return this.get(n, byArray, 0, byArray.length);
    }

    @Override
    public ByteBuf get(byte[] byArray, int n, int n2) {
        this.buf.get(byArray, n, n2);
        return this;
    }

    @Override
    public ByteBuf get(int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray[n2 + i] = this.buf.get(n + i);
        }
        return this;
    }

    @Override
    public long getLong() {
        return this.buf.getLong();
    }

    @Override
    public long getLong(int n) {
        return this.buf.getLong(n);
    }

    @Override
    public double getDouble() {
        return this.buf.getDouble();
    }

    @Override
    public double getDouble(int n) {
        return this.buf.getDouble(n);
    }

    @Override
    public int getInt() {
        return this.buf.getInt();
    }

    @Override
    public int getInt(int n) {
        return this.buf.getInt(n);
    }

    @Override
    public int position() {
        return this.buf.position();
    }

    @Override
    public ByteBuf limit(int n) {
        ((Buffer)this.buf).limit(n);
        return this;
    }

    @Override
    public ByteBuf asReadOnly() {
        return new ByteBufNIO(this.buf.asReadOnlyBuffer());
    }

    @Override
    public ByteBuf duplicate() {
        return new ByteBufNIO(this.buf.duplicate());
    }

    @Override
    public ByteBuffer asNIO() {
        return this.buf;
    }
}

