/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.UuidRepresentation;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectionCodecProvider;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.IterableCodecProvider;
import org.bson.codecs.MapCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.json.JsonMode;
import org.bson.json.JsonReader;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;
import org.bson.types.ObjectId;

public class Document
implements Map<String, Object>,
Serializable,
Bson {
    private static final Codec<Document> DEFAULT_CODEC = CodecRegistries.withUuidRepresentation(CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new CollectionCodecProvider(), new IterableCodecProvider(), new BsonValueCodecProvider(), new DocumentCodecProvider(), new MapCodecProvider())), UuidRepresentation.STANDARD).get(Document.class);
    private static final long serialVersionUID = 6297731997167536582L;
    private final LinkedHashMap<String, Object> documentAsMap;

    public Document() {
        this.documentAsMap = new LinkedHashMap();
    }

    public Document(String string, Object object) {
        this.documentAsMap = new LinkedHashMap();
        this.documentAsMap.put(string, object);
    }

    public Document(Map<String, ?> map) {
        this.documentAsMap = new LinkedHashMap(map);
    }

    public static Document parse(String string) {
        return Document.parse(string, DEFAULT_CODEC);
    }

    public static Document parse(String string, Decoder<Document> decoder) {
        Assertions.notNull("codec", decoder);
        JsonReader jsonReader = new JsonReader(string);
        return decoder.decode(jsonReader, DecoderContext.builder().build());
    }

    public <C> BsonDocument toBsonDocument(Class<C> clazz, CodecRegistry codecRegistry) {
        return new BsonDocumentWrapper<Document>(this, codecRegistry.get(Document.class));
    }

    public Document append(String string, Object object) {
        this.documentAsMap.put(string, object);
        return this;
    }

    public <T> T get(Object object, Class<T> clazz) {
        Assertions.notNull("clazz", clazz);
        return clazz.cast(this.documentAsMap.get(object));
    }

    public <T> T get(Object object, T t) {
        Assertions.notNull("defaultValue", t);
        Object object2 = this.documentAsMap.get(object);
        return (T)(object2 == null ? t : object2);
    }

    public <T> T getEmbedded(List<?> list, Class<T> clazz) {
        Assertions.notNull("keys", list);
        Assertions.isTrue("keys", !list.isEmpty());
        Assertions.notNull("clazz", clazz);
        return this.getEmbeddedValue(list, clazz, null);
    }

    public <T> T getEmbedded(List<?> list, T t) {
        Assertions.notNull("keys", list);
        Assertions.isTrue("keys", !list.isEmpty());
        Assertions.notNull("defaultValue", t);
        return this.getEmbeddedValue(list, null, t);
    }

    private <T> T getEmbeddedValue(List<?> list, Class<T> clazz, T t) {
        Object object = this;
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if ((object = ((Document)object).get(obj)) instanceof Document) continue;
            if (object == null) {
                return t;
            }
            if (!iterator.hasNext()) continue;
            throw new ClassCastException(String.format("At key %s, the value is not a Document (%s)", obj, object.getClass().getName()));
        }
        return (T)(clazz != null ? clazz.cast(object) : object);
    }

    public Integer getInteger(Object object) {
        return (Integer)this.get(object);
    }

    public int getInteger(Object object, int n) {
        return this.get(object, n);
    }

    public Long getLong(Object object) {
        return (Long)this.get(object);
    }

    public Double getDouble(Object object) {
        return (Double)this.get(object);
    }

    public String getString(Object object) {
        return (String)this.get(object);
    }

    public Boolean getBoolean(Object object) {
        return (Boolean)this.get(object);
    }

    public boolean getBoolean(Object object, boolean bl) {
        return this.get(object, bl);
    }

    public ObjectId getObjectId(Object object) {
        return (ObjectId)this.get(object);
    }

    public Date getDate(Object object) {
        return (Date)this.get(object);
    }

    public <T> List<T> getList(Object object, Class<T> clazz) {
        Assertions.notNull("clazz", clazz);
        return this.constructValuesList(object, clazz, null);
    }

    public <T> List<T> getList(Object object, Class<T> clazz, List<T> list) {
        Assertions.notNull("defaultValue", list);
        Assertions.notNull("clazz", clazz);
        return this.constructValuesList(object, clazz, list);
    }

    private <T> List<T> constructValuesList(Object object, Class<T> clazz, List<T> list) {
        List list2 = (List)((Object)this.get(object, (T)List.class));
        if (list2 == null) {
            return list;
        }
        for (Object e : list2) {
            if (e == null || clazz.isAssignableFrom(e.getClass())) continue;
            throw new ClassCastException(String.format("List element cannot be cast to %s", clazz.getName()));
        }
        return list2;
    }

    public String toJson() {
        return this.toJson(JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build());
    }

    public String toJson(JsonWriterSettings jsonWriterSettings) {
        return this.toJson(jsonWriterSettings, DEFAULT_CODEC);
    }

    public String toJson(Encoder<Document> encoder) {
        return this.toJson(JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build(), encoder);
    }

    public String toJson(JsonWriterSettings jsonWriterSettings, Encoder<Document> encoder) {
        JsonWriter jsonWriter = new JsonWriter(new StringWriter(), jsonWriterSettings);
        encoder.encode(jsonWriter, this, EncoderContext.builder().build());
        return jsonWriter.getWriter().toString();
    }

    @Override
    public int size() {
        return this.documentAsMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.documentAsMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object object) {
        return this.documentAsMap.containsValue(object);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.documentAsMap.containsKey(object);
    }

    @Override
    public Object get(Object object) {
        return this.documentAsMap.get(object);
    }

    @Override
    public Object put(String string, Object object) {
        return this.documentAsMap.put(string, object);
    }

    @Override
    public Object remove(Object object) {
        return this.documentAsMap.remove(object);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.documentAsMap.putAll(map);
    }

    @Override
    public void clear() {
        this.documentAsMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.documentAsMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.documentAsMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.documentAsMap.entrySet();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Document document = (Document)object;
        return this.documentAsMap.equals(document.documentAsMap);
    }

    @Override
    public int hashCode() {
        return this.documentAsMap.hashCode();
    }

    public String toString() {
        return "Document{" + this.documentAsMap + '}';
    }
}

