/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.List;
import org.bson.BasicBSONObject;
import org.bson.EmptyBSONCallback;
import org.bson.LazyBSONList;
import org.bson.LazyBSONObject;
import org.bson.types.ObjectId;

public class LazyBSONCallback
extends EmptyBSONCallback {
    private Object root;

    @Override
    public void reset() {
        this.root = null;
    }

    @Override
    public Object get() {
        return this.getRoot();
    }

    @Override
    public void gotBinary(String string, byte by, byte[] byArray) {
        this.setRoot(this.createObject(byArray, 0));
    }

    public Object createObject(byte[] byArray, int n) {
        return new LazyBSONObject(byArray, n, this);
    }

    public List createArray(byte[] byArray, int n) {
        return new LazyBSONList(byArray, n, this);
    }

    public Object createDBRef(String string, ObjectId objectId) {
        return new BasicBSONObject("$ns", string).append("$id", objectId);
    }

    private Object getRoot() {
        return this.root;
    }

    private void setRoot(Object object) {
        this.root = object;
    }
}

