/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BSONException;
import org.bson.BSONObject;
import org.bson.Bits;
import org.bson.LazyBSONCallback;

public class LazyBSONDecoder
implements BSONDecoder {
    private static final int BYTES_IN_INTEGER = 4;

    @Override
    public BSONObject readObject(byte[] byArray) {
        LazyBSONCallback lazyBSONCallback = new LazyBSONCallback();
        this.decode(byArray, (BSONCallback)lazyBSONCallback);
        return (BSONObject)lazyBSONCallback.get();
    }

    @Override
    public BSONObject readObject(InputStream inputStream) throws IOException {
        LazyBSONCallback lazyBSONCallback = new LazyBSONCallback();
        this.decode(inputStream, (BSONCallback)lazyBSONCallback);
        return (BSONObject)lazyBSONCallback.get();
    }

    @Override
    public int decode(byte[] byArray, BSONCallback bSONCallback) {
        try {
            return this.decode(new ByteArrayInputStream(byArray), bSONCallback);
        }
        catch (IOException iOException) {
            throw new BSONException("Invalid bytes received", iOException);
        }
    }

    @Override
    public int decode(InputStream inputStream, BSONCallback bSONCallback) throws IOException {
        byte[] byArray = new byte[4];
        int n = Bits.readInt(inputStream, byArray);
        byte[] byArray2 = Arrays.copyOf(byArray, n);
        Bits.readFully(inputStream, byArray2, 4, n - 4);
        bSONCallback.gotBinary(null, (byte)0, byArray2);
        return n;
    }
}

