/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.bson.BsonBinaryReader;
import org.bson.BsonType;
import org.bson.LazyBSONCallback;
import org.bson.LazyBSONObject;

public class LazyBSONList
extends LazyBSONObject
implements List {
    public LazyBSONList(byte[] byArray, LazyBSONCallback lazyBSONCallback) {
        super(byArray, lazyBSONCallback);
    }

    public LazyBSONList(byte[] byArray, int n, LazyBSONCallback lazyBSONCallback) {
        super(byArray, n, lazyBSONCallback);
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) > -1;
    }

    @Override
    public Iterator iterator() {
        return new LazyBSONListIterator();
    }

    @Override
    public boolean containsAll(Collection collection) {
        HashSet hashSet = new HashSet();
        for (Object e : this) {
            hashSet.add(e);
        }
        return hashSet.containsAll(collection);
    }

    public Object get(int n) {
        return this.get(String.valueOf(n));
    }

    @Override
    public int indexOf(Object object) {
        Iterator iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (object.equals(iterator.next())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = -1;
        Iterator iterator = this.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            if (object.equals(iterator.next())) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException("Operation is not supported instance of this type");
    }

    public ListIterator listIterator(int n) {
        throw new UnsupportedOperationException("Operation is not supported instance of this type");
    }

    @Override
    public boolean add(Object object) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException("Object is read only");
    }

    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Object is read only");
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException("Object is read only");
    }

    public void add(int n, Object object) {
        throw new UnsupportedOperationException("Object is read only");
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException("Object is read only");
    }

    public List subList(int n, int n2) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public class LazyBSONListIterator
    implements Iterator {
        private final BsonBinaryReader reader;
        private BsonType cachedBsonType;

        public LazyBSONListIterator() {
            this.reader = LazyBSONList.this.getBsonReader();
            this.reader.readStartDocument();
        }

        @Override
        public boolean hasNext() {
            if (this.cachedBsonType == null) {
                this.cachedBsonType = this.reader.readBsonType();
            }
            return this.cachedBsonType != BsonType.END_OF_DOCUMENT;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cachedBsonType = null;
            this.reader.readName();
            return LazyBSONList.this.readValue(this.reader);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported");
        }
    }
}

