/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.BsonBinary;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinarySubType;
import org.bson.BsonDbPointer;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.ByteBufNIO;
import org.bson.LazyBSONCallback;
import org.bson.io.ByteBufferBsonInput;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.Symbol;

public class LazyBSONObject
implements BSONObject {
    private final byte[] bytes;
    private final int offset;
    private final LazyBSONCallback callback;

    public LazyBSONObject(byte[] byArray, LazyBSONCallback lazyBSONCallback) {
        this(byArray, 0, lazyBSONCallback);
    }

    public LazyBSONObject(byte[] byArray, int n, LazyBSONCallback lazyBSONCallback) {
        this.bytes = byArray;
        this.callback = lazyBSONCallback;
        this.offset = n;
    }

    protected int getOffset() {
        return this.offset;
    }

    protected byte[] getBytes() {
        return this.bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String string) {
        Object object;
        try (BsonBinaryReader bsonBinaryReader = this.getBsonReader();){
            bsonBinaryReader.readStartDocument();
            object = null;
            while (bsonBinaryReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                if (string.equals(bsonBinaryReader.readName())) {
                    object = this.readValue(bsonBinaryReader);
                    break;
                }
                bsonBinaryReader.skipValue();
            }
        }
        return object;
    }

    @Override
    public boolean containsField(String string) {
        try (BsonBinaryReader bsonBinaryReader = this.getBsonReader();){
            bsonBinaryReader.readStartDocument();
            while (bsonBinaryReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                if (bsonBinaryReader.readName().equals(string)) {
                    boolean bl = true;
                    return bl;
                }
                bsonBinaryReader.skipValue();
            }
        }
        return false;
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        try (BsonBinaryReader bsonBinaryReader = this.getBsonReader();){
            bsonBinaryReader.readStartDocument();
            while (bsonBinaryReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                linkedHashSet.add(bsonBinaryReader.readName());
                bsonBinaryReader.skipValue();
            }
            bsonBinaryReader.readEndDocument();
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    Object readValue(BsonBinaryReader bsonBinaryReader) {
        switch (bsonBinaryReader.getCurrentBsonType()) {
            case DOCUMENT: {
                return this.readDocument(bsonBinaryReader);
            }
            case ARRAY: {
                return this.readArray(bsonBinaryReader);
            }
            case DOUBLE: {
                return bsonBinaryReader.readDouble();
            }
            case STRING: {
                return bsonBinaryReader.readString();
            }
            case BINARY: {
                byte by = bsonBinaryReader.peekBinarySubType();
                BsonBinary bsonBinary = bsonBinaryReader.readBinaryData();
                if (by == BsonBinarySubType.BINARY.getValue() || by == BsonBinarySubType.OLD_BINARY.getValue()) {
                    return bsonBinary.getData();
                }
                return new Binary(bsonBinary.getType(), bsonBinary.getData());
            }
            case NULL: {
                bsonBinaryReader.readNull();
                return null;
            }
            case UNDEFINED: {
                bsonBinaryReader.readUndefined();
                return null;
            }
            case OBJECT_ID: {
                return bsonBinaryReader.readObjectId();
            }
            case BOOLEAN: {
                return bsonBinaryReader.readBoolean();
            }
            case DATE_TIME: {
                return new Date(bsonBinaryReader.readDateTime());
            }
            case REGULAR_EXPRESSION: {
                BsonRegularExpression bsonRegularExpression = bsonBinaryReader.readRegularExpression();
                return Pattern.compile(bsonRegularExpression.getPattern(), BSON.regexFlags(bsonRegularExpression.getOptions()));
            }
            case DB_POINTER: {
                BsonDbPointer bsonDbPointer = bsonBinaryReader.readDBPointer();
                return this.callback.createDBRef(bsonDbPointer.getNamespace(), bsonDbPointer.getId());
            }
            case JAVASCRIPT: {
                return new Code(bsonBinaryReader.readJavaScript());
            }
            case SYMBOL: {
                return new Symbol(bsonBinaryReader.readSymbol());
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return new CodeWScope(bsonBinaryReader.readJavaScriptWithScope(), (BSONObject)this.readJavaScriptWithScopeDocument(bsonBinaryReader));
            }
            case INT32: {
                return bsonBinaryReader.readInt32();
            }
            case TIMESTAMP: {
                BsonTimestamp bsonTimestamp = bsonBinaryReader.readTimestamp();
                return new BSONTimestamp(bsonTimestamp.getTime(), bsonTimestamp.getInc());
            }
            case INT64: {
                return bsonBinaryReader.readInt64();
            }
            case DECIMAL128: {
                return bsonBinaryReader.readDecimal128();
            }
            case MIN_KEY: {
                bsonBinaryReader.readMinKey();
                return new MinKey();
            }
            case MAX_KEY: {
                bsonBinaryReader.readMaxKey();
                return new MaxKey();
            }
        }
        throw new IllegalArgumentException("unhandled BSON type: " + (Object)((Object)bsonBinaryReader.getCurrentBsonType()));
    }

    private Object readArray(BsonBinaryReader bsonBinaryReader) {
        int n = bsonBinaryReader.getBsonInput().getPosition();
        bsonBinaryReader.skipValue();
        return this.callback.createArray(this.bytes, this.offset + n);
    }

    private Object readDocument(BsonBinaryReader bsonBinaryReader) {
        int n = bsonBinaryReader.getBsonInput().getPosition();
        bsonBinaryReader.skipValue();
        return this.callback.createObject(this.bytes, this.offset + n);
    }

    private Object readJavaScriptWithScopeDocument(BsonBinaryReader bsonBinaryReader) {
        int n = bsonBinaryReader.getBsonInput().getPosition();
        bsonBinaryReader.readStartDocument();
        while (bsonBinaryReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            bsonBinaryReader.skipName();
            bsonBinaryReader.skipValue();
        }
        bsonBinaryReader.readEndDocument();
        return this.callback.createObject(this.bytes, this.offset + n);
    }

    BsonBinaryReader getBsonReader() {
        ByteBuffer byteBuffer = this.getBufferForInternalBytes();
        return new BsonBinaryReader(new ByteBufferBsonInput(new ByteBufNIO(byteBuffer)));
    }

    private ByteBuffer getBufferForInternalBytes() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes, this.offset, this.bytes.length - this.offset).slice();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ((Buffer)byteBuffer).limit(byteBuffer.getInt());
        ((Buffer)byteBuffer).rewind();
        return byteBuffer;
    }

    public boolean isEmpty() {
        return this.keySet().size() == 0;
    }

    public int getBSONSize() {
        return this.getBufferForInternalBytes().getInt();
    }

    public int pipe(OutputStream outputStream) throws IOException {
        WritableByteChannel writableByteChannel = Channels.newChannel(outputStream);
        return writableByteChannel.write(this.getBufferForInternalBytes());
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        final ArrayList<AbstractMap.SimpleImmutableEntry<String, Object>> arrayList = new ArrayList<AbstractMap.SimpleImmutableEntry<String, Object>>();
        try (BsonBinaryReader bsonBinaryReader = this.getBsonReader();){
            bsonBinaryReader.readStartDocument();
            while (bsonBinaryReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                arrayList.add(new AbstractMap.SimpleImmutableEntry<String, Object>(bsonBinaryReader.readName(), this.readValue(bsonBinaryReader)));
            }
            bsonBinaryReader.readEndDocument();
        }
        return new Set<Map.Entry<String, Object>>(){

            @Override
            public int size() {
                return arrayList.size();
            }

            @Override
            public boolean isEmpty() {
                return arrayList.isEmpty();
            }

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return arrayList.iterator();
            }

            @Override
            public Object[] toArray() {
                return arrayList.toArray();
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return arrayList.toArray(TArray);
            }

            @Override
            public boolean contains(Object object) {
                return arrayList.contains(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return arrayList.containsAll(collection);
            }

            @Override
            public boolean add(Map.Entry<String, Object> entry) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<String, Object>> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.getBSONSize();
        for (int i = this.offset; i < this.offset + n2; ++i) {
            n = 31 * n + this.bytes[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LazyBSONObject lazyBSONObject = (LazyBSONObject)object;
        if (this.bytes == lazyBSONObject.bytes && this.offset == lazyBSONObject.offset) {
            return true;
        }
        if (this.bytes == null || lazyBSONObject.bytes == null) {
            return false;
        }
        if (this.bytes.length == 0 || lazyBSONObject.bytes.length == 0) {
            return false;
        }
        int n = this.bytes[this.offset];
        if (lazyBSONObject.bytes[lazyBSONObject.offset] != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.bytes[this.offset + i] == lazyBSONObject.bytes[lazyBSONObject.offset + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object put(String string, Object object) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    public void putAll(BSONObject bSONObject) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    public void putAll(Map map) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    public Object removeField(String string) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    public Map toMap() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            linkedHashMap.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }
}

