/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.Arrays;
import java.util.Objects;
import org.bson.BinaryVector;
import org.bson.annotations.Beta;
import org.bson.annotations.Reason;
import org.bson.assertions.Assertions;

@Beta(value={Reason.SERVER})
public final class PackedBitBinaryVector
extends BinaryVector {
    private final byte padding;
    private final byte[] data;

    PackedBitBinaryVector(byte[] byArray, byte by) {
        super(BinaryVector.DataType.PACKED_BIT);
        this.data = Assertions.assertNotNull(byArray);
        this.padding = by;
    }

    public byte[] getData() {
        return Assertions.assertNotNull(this.data);
    }

    public byte getPadding() {
        return this.padding;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PackedBitBinaryVector packedBitBinaryVector = (PackedBitBinaryVector)object;
        return this.padding == packedBitBinaryVector.padding && Arrays.equals(this.data, packedBitBinaryVector.data);
    }

    public int hashCode() {
        return Objects.hash(this.padding, Arrays.hashCode(this.data));
    }

    public String toString() {
        return "PackedBitVector{padding=" + this.padding + ", data=" + Arrays.toString(this.data) + ", dataType=" + (Object)((Object)this.getDataType()) + '}';
    }
}

