/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.bson.BsonArray;
import org.bson.BsonBinaryReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;
import org.bson.RawBsonValueHelper;
import org.bson.assertions.Assertions;
import org.bson.io.ByteBufferBsonInput;

public class RawBsonArray
extends BsonArray
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String IMMUTABLE_MSG = "RawBsonArray instances are immutable";
    private final transient RawBsonArrayList delegate;

    public RawBsonArray(byte[] byArray) {
        this(Assertions.notNull("bytes", byArray), 0, byArray.length);
    }

    public RawBsonArray(byte[] byArray, int n, int n2) {
        this(new RawBsonArrayList(byArray, n, n2));
    }

    private RawBsonArray(RawBsonArrayList rawBsonArrayList) {
        super(rawBsonArrayList, false);
        this.delegate = rawBsonArrayList;
    }

    ByteBuf getByteBuffer() {
        return this.delegate.getByteBuffer();
    }

    @Override
    public boolean add(BsonValue bsonValue) {
        throw new UnsupportedOperationException(IMMUTABLE_MSG);
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException(IMMUTABLE_MSG);
    }

    @Override
    public boolean addAll(Collection<? extends BsonValue> collection) {
        throw new UnsupportedOperationException(IMMUTABLE_MSG);
    }

    @Override
    public boolean addAll(int n, Collection<? extends BsonValue> collection) {
        throw new UnsupportedOperationException(IMMUTABLE_MSG);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException(IMMUTABLE_MSG);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException(IMMUTABLE_MSG);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(IMMUTABLE_MSG);
    }

    @Override
    public BsonValue set(int n, BsonValue bsonValue) {
        throw new UnsupportedOperationException(IMMUTABLE_MSG);
    }

    @Override
    public void add(int n, BsonValue bsonValue) {
        throw new UnsupportedOperationException(IMMUTABLE_MSG);
    }

    @Override
    public BsonValue remove(int n) {
        throw new UnsupportedOperationException(IMMUTABLE_MSG);
    }

    @Override
    public BsonArray clone() {
        return new RawBsonArray((byte[])this.delegate.bytes.clone(), this.delegate.offset, this.delegate.length);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private Object writeReplace() {
        return new SerializationProxy(this.delegate.bytes, this.delegate.offset, this.delegate.length);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    static class RawBsonArrayList
    extends AbstractList<BsonValue> {
        private static final int MIN_BSON_ARRAY_SIZE = 5;
        private Integer cachedSize;
        private final byte[] bytes;
        private final int offset;
        private final int length;

        RawBsonArrayList(byte[] byArray, int n, int n2) {
            Assertions.notNull("bytes", byArray);
            Assertions.isTrueArgument("offset >= 0", n >= 0);
            Assertions.isTrueArgument("offset < bytes.length", n < byArray.length);
            Assertions.isTrueArgument("length <= bytes.length - offset", n2 <= byArray.length - n);
            Assertions.isTrueArgument("length >= 5", n2 >= 5);
            this.bytes = byArray;
            this.offset = n;
            this.length = n2;
        }

        @Override
        public BsonValue get(int n) {
            if (n < 0) {
                throw new IndexOutOfBoundsException();
            }
            int n2 = 0;
            try (BsonBinaryReader bsonBinaryReader = this.createReader();){
                bsonBinaryReader.readStartDocument();
                while (bsonBinaryReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    bsonBinaryReader.skipName();
                    if (n2 == n) {
                        BsonValue bsonValue = RawBsonValueHelper.decode(this.bytes, bsonBinaryReader);
                        return bsonValue;
                    }
                    bsonBinaryReader.skipValue();
                    ++n2;
                }
                bsonBinaryReader.readEndDocument();
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            if (this.cachedSize != null) {
                return this.cachedSize;
            }
            int n = 0;
            try (BsonBinaryReader bsonBinaryReader = this.createReader();){
                bsonBinaryReader.readStartDocument();
                while (bsonBinaryReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    ++n;
                    bsonBinaryReader.readName();
                    bsonBinaryReader.skipValue();
                }
                bsonBinaryReader.readEndDocument();
            }
            this.cachedSize = n;
            return this.cachedSize;
        }

        @Override
        public Iterator<BsonValue> iterator() {
            return new Itr();
        }

        @Override
        public ListIterator<BsonValue> listIterator() {
            return new ListItr(0);
        }

        @Override
        public ListIterator<BsonValue> listIterator(int n) {
            return new ListItr(n);
        }

        private BsonBinaryReader createReader() {
            return new BsonBinaryReader(new ByteBufferBsonInput(this.getByteBuffer()));
        }

        ByteBuf getByteBuffer() {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes, this.offset, this.length);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            return new ByteBufNIO(byteBuffer);
        }

        private class Itr
        implements Iterator<BsonValue> {
            private int cursor = 0;
            private BsonBinaryReader bsonReader;
            private int currentPosition = 0;

            Itr() {
                this(0);
            }

            Itr(int n) {
                this.setIterator(n);
            }

            @Override
            public boolean hasNext() {
                boolean bl;
                boolean bl2 = bl = this.cursor != RawBsonArrayList.this.size();
                if (!bl) {
                    this.bsonReader.close();
                }
                return bl;
            }

            @Override
            public BsonValue next() {
                while (this.cursor > this.currentPosition && this.bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    this.bsonReader.skipName();
                    this.bsonReader.skipValue();
                    ++this.currentPosition;
                }
                if (this.bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    this.bsonReader.skipName();
                    ++this.cursor;
                    this.currentPosition = this.cursor;
                    return RawBsonValueHelper.decode(RawBsonArrayList.this.bytes, this.bsonReader);
                }
                this.bsonReader.close();
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException(RawBsonArray.IMMUTABLE_MSG);
            }

            public int getCursor() {
                return this.cursor;
            }

            public void setCursor(int n) {
                this.cursor = n;
            }

            void setIterator(int n) {
                this.cursor = n;
                this.currentPosition = 0;
                if (this.bsonReader != null) {
                    this.bsonReader.close();
                }
                this.bsonReader = RawBsonArrayList.this.createReader();
                this.bsonReader.readStartDocument();
            }
        }

        private class ListItr
        extends Itr
        implements ListIterator<BsonValue> {
            ListItr(int n) {
                super(n);
            }

            @Override
            public boolean hasPrevious() {
                return this.getCursor() != 0;
            }

            @Override
            public BsonValue previous() {
                try {
                    BsonValue bsonValue = RawBsonArrayList.this.get(this.previousIndex());
                    this.setIterator(this.previousIndex());
                    return bsonValue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public int nextIndex() {
                return this.getCursor();
            }

            @Override
            public int previousIndex() {
                return this.getCursor() - 1;
            }

            @Override
            public void set(BsonValue bsonValue) {
                throw new UnsupportedOperationException(RawBsonArray.IMMUTABLE_MSG);
            }

            @Override
            public void add(BsonValue bsonValue) {
                throw new UnsupportedOperationException(RawBsonArray.IMMUTABLE_MSG);
            }
        }
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final byte[] bytes;

        SerializationProxy(byte[] byArray, int n, int n2) {
            if (byArray.length == n2) {
                this.bytes = byArray;
            } else {
                this.bytes = new byte[n2];
                System.arraycopy(byArray, n, this.bytes, 0, n2);
            }
        }

        private Object readResolve() {
            return new RawBsonArray(this.bytes);
        }
    }
}

