/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;
import org.bson.RawBsonValueHelper;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.RawBsonDocumentCodec;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.ByteBufferBsonInput;
import org.bson.json.JsonMode;
import org.bson.json.JsonReader;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;

public final class RawBsonDocument
extends BsonDocument {
    private static final long serialVersionUID = 1L;
    private static final int MIN_BSON_DOCUMENT_SIZE = 5;
    private final byte[] bytes;
    private final int offset;
    private final int length;

    public static RawBsonDocument parse(String string) {
        Assertions.notNull("json", string);
        return new RawBsonDocumentCodec().decode(new JsonReader(string), DecoderContext.builder().build());
    }

    public RawBsonDocument(byte[] byArray) {
        this(Assertions.notNull("bytes", byArray), 0, byArray.length);
    }

    public RawBsonDocument(byte[] byArray, int n, int n2) {
        Assertions.notNull("bytes", byArray);
        Assertions.isTrueArgument("offset >= 0", n >= 0);
        Assertions.isTrueArgument("offset < bytes.length", n < byArray.length);
        Assertions.isTrueArgument("length <= bytes.length - offset", n2 <= byArray.length - n);
        Assertions.isTrueArgument("length >= 5", n2 >= 5);
        this.bytes = byArray;
        this.offset = n;
        this.length = n2;
    }

    public <T> RawBsonDocument(T t, Codec<T> codec) {
        Assertions.notNull("document", t);
        Assertions.notNull("codec", codec);
        BasicOutputBuffer basicOutputBuffer = new BasicOutputBuffer();
        try (BsonBinaryWriter bsonBinaryWriter = new BsonBinaryWriter(basicOutputBuffer);){
            codec.encode(bsonBinaryWriter, t, EncoderContext.builder().build());
            this.bytes = basicOutputBuffer.getInternalBuffer();
            this.offset = 0;
            this.length = basicOutputBuffer.getPosition();
        }
    }

    public ByteBuf getByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes, this.offset, this.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return new ByteBufNIO(byteBuffer);
    }

    public <T> T decode(Codec<T> codec) {
        return this.decode((Decoder<T>)codec);
    }

    public <T> T decode(Decoder<T> decoder) {
        try (BsonBinaryReader bsonBinaryReader = this.createReader();){
            T t = decoder.decode(bsonBinaryReader, DecoderContext.builder().build());
            return t;
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("RawBsonDocument instances are immutable");
    }

    @Override
    public BsonValue put(String string, BsonValue bsonValue) {
        throw new UnsupportedOperationException("RawBsonDocument instances are immutable");
    }

    @Override
    public BsonDocument append(String string, BsonValue bsonValue) {
        throw new UnsupportedOperationException("RawBsonDocument instances are immutable");
    }

    @Override
    public void putAll(Map<? extends String, ? extends BsonValue> map) {
        throw new UnsupportedOperationException("RawBsonDocument instances are immutable");
    }

    @Override
    public BsonValue remove(Object object) {
        throw new UnsupportedOperationException("RawBsonDocument instances are immutable");
    }

    @Override
    public boolean isEmpty() {
        try (BsonBinaryReader bsonBinaryReader = this.createReader();){
            bsonBinaryReader.readStartDocument();
            if (bsonBinaryReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                boolean bl = false;
                return bl;
            }
            bsonBinaryReader.readEndDocument();
        }
        return true;
    }

    @Override
    public int size() {
        int n = 0;
        try (BsonBinaryReader bsonBinaryReader = this.createReader();){
            bsonBinaryReader.readStartDocument();
            while (bsonBinaryReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                ++n;
                bsonBinaryReader.readName();
                bsonBinaryReader.skipValue();
            }
            bsonBinaryReader.readEndDocument();
        }
        return n;
    }

    @Override
    public Set<Map.Entry<String, BsonValue>> entrySet() {
        return this.toBaseBsonDocument().entrySet();
    }

    @Override
    public Collection<BsonValue> values() {
        return this.toBaseBsonDocument().values();
    }

    @Override
    public Set<String> keySet() {
        return this.toBaseBsonDocument().keySet();
    }

    @Override
    public String getFirstKey() {
        try (BsonBinaryReader bsonBinaryReader = this.createReader();){
            bsonBinaryReader.readStartDocument();
            try {
                String string = bsonBinaryReader.readName();
                return string;
            }
            catch (BsonInvalidOperationException bsonInvalidOperationException) {
                throw new NoSuchElementException();
            }
        }
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        try (BsonBinaryReader bsonBinaryReader = this.createReader();){
            bsonBinaryReader.readStartDocument();
            while (bsonBinaryReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                if (bsonBinaryReader.readName().equals(object)) {
                    boolean bl = true;
                    return bl;
                }
                bsonBinaryReader.skipValue();
            }
            bsonBinaryReader.readEndDocument();
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        try (BsonBinaryReader bsonBinaryReader = this.createReader();){
            bsonBinaryReader.readStartDocument();
            while (bsonBinaryReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                bsonBinaryReader.skipName();
                if (!RawBsonValueHelper.decode(this.bytes, bsonBinaryReader).equals(object)) continue;
                boolean bl = true;
                return bl;
            }
            bsonBinaryReader.readEndDocument();
        }
        return false;
    }

    @Override
    public BsonValue get(Object object) {
        Assertions.notNull("key", object);
        try (BsonBinaryReader bsonBinaryReader = this.createReader();){
            bsonBinaryReader.readStartDocument();
            while (bsonBinaryReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                if (bsonBinaryReader.readName().equals(object)) {
                    BsonValue bsonValue = RawBsonValueHelper.decode(this.bytes, bsonBinaryReader);
                    return bsonValue;
                }
                bsonBinaryReader.skipValue();
            }
            bsonBinaryReader.readEndDocument();
        }
        return null;
    }

    @Override
    public String toJson() {
        return this.toJson(JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build());
    }

    @Override
    public String toJson(JsonWriterSettings jsonWriterSettings) {
        StringWriter stringWriter = new StringWriter();
        new RawBsonDocumentCodec().encode((BsonWriter)new JsonWriter(stringWriter, jsonWriterSettings), this, EncoderContext.builder().build());
        return stringWriter.toString();
    }

    @Override
    public boolean equals(Object object) {
        return this.toBaseBsonDocument().equals(object);
    }

    @Override
    public int hashCode() {
        return this.toBaseBsonDocument().hashCode();
    }

    @Override
    public BsonDocument clone() {
        return new RawBsonDocument((byte[])this.bytes.clone(), this.offset, this.length);
    }

    private BsonBinaryReader createReader() {
        return new BsonBinaryReader(new ByteBufferBsonInput(this.getByteBuffer()));
    }

    private BsonDocument toBaseBsonDocument() {
        try (BsonBinaryReader bsonBinaryReader = this.createReader();){
            BsonDocument bsonDocument = new BsonDocumentCodec().decode(bsonBinaryReader, DecoderContext.builder().build());
            return bsonDocument;
        }
    }

    private Object writeReplace() {
        return new SerializationProxy(this.bytes, this.offset, this.length);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final byte[] bytes;

        SerializationProxy(byte[] byArray, int n, int n2) {
            if (byArray.length == n2) {
                this.bytes = byArray;
            } else {
                this.bytes = new byte[n2];
                System.arraycopy(byArray, n, this.bytes, 0, n2);
            }
        }

        private Object readResolve() {
            return new RawBsonDocument(this.bytes);
        }
    }
}

