/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.BsonBinaryReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.RawBsonArray;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BsonInputMark;

final class RawBsonValueHelper {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());

    static BsonValue decode(byte[] byArray, BsonBinaryReader bsonBinaryReader) {
        if (bsonBinaryReader.getCurrentBsonType() == BsonType.DOCUMENT || bsonBinaryReader.getCurrentBsonType() == BsonType.ARRAY) {
            int n = bsonBinaryReader.getBsonInput().getPosition();
            BsonInputMark bsonInputMark = bsonBinaryReader.getBsonInput().getMark(4);
            int n2 = bsonBinaryReader.getBsonInput().readInt32();
            bsonInputMark.reset();
            bsonBinaryReader.skipValue();
            if (bsonBinaryReader.getCurrentBsonType() == BsonType.DOCUMENT) {
                return new RawBsonDocument(byArray, n, n2);
            }
            return new RawBsonArray(byArray, n, n2);
        }
        return (BsonValue)REGISTRY.get(BsonValueCodecProvider.getClassForBsonType(bsonBinaryReader.getCurrentBsonType())).decode(bsonBinaryReader, DecoderContext.builder().build());
    }

    private RawBsonValueHelper() {
    }
}

