/*
 * Decompiled with CFR 0.152.
 */
package org.bson.assertions;

import javax.annotation.Nullable;

public final class Assertions {
    public static <T> T notNull(String string, T t) {
        if (t == null) {
            throw new IllegalArgumentException(string + " can not be null");
        }
        return t;
    }

    public static void isTrue(String string, boolean bl) {
        if (!bl) {
            throw new IllegalStateException("state should be: " + string);
        }
    }

    public static void isTrueArgument(String string, boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException("state should be: " + string);
        }
    }

    public static <T> T isTrueArgument(String string, T t, boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException("state should be: " + string);
        }
        return t;
    }

    public static AssertionError fail() throws AssertionError {
        throw new AssertionError();
    }

    public static AssertionError fail(String string) throws AssertionError {
        throw new AssertionError((Object)Assertions.assertNotNull(string));
    }

    public static <T> T assertNotNull(@Nullable T t) throws AssertionError {
        if (t == null) {
            throw new AssertionError();
        }
        return t;
    }

    public static void assertTrue(String string, boolean bl) {
        if (!bl) {
            throw new AssertionError((Object)("state should be: " + Assertions.assertNotNull(string)));
        }
    }

    public static <T> T convertToType(Class<T> clazz, Object object, String string) {
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException(string);
        }
        return (T)object;
    }

    private Assertions() {
    }
}

