/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;

abstract class AbstractCollectionCodec<T, C extends Collection<T>>
implements Codec<C> {
    private final Class<C> clazz;
    private final Supplier<C> supplier;

    AbstractCollectionCodec(Class<C> clazz) {
        this.clazz = Assertions.notNull("clazz", clazz);
        Class clazz2 = clazz;
        if (clazz2 == Collection.class || clazz2 == List.class || clazz2 == AbstractCollection.class || clazz2 == AbstractList.class || clazz2 == ArrayList.class) {
            this.supplier = () -> new ArrayList();
        } else if (clazz2 == Set.class || clazz2 == AbstractSet.class || clazz2 == HashSet.class) {
            this.supplier = () -> new HashSet();
        } else if (clazz2 == NavigableSet.class || clazz2 == SortedSet.class || clazz2 == TreeSet.class) {
            this.supplier = () -> new TreeSet();
        } else {
            Supplier<Collection> supplier;
            try {
                Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                supplier = () -> {
                    try {
                        return (Collection)constructor.newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                        throw new CodecConfigurationException(String.format("Can not invoke no-args constructor for Collection class %s", clazz), reflectiveOperationException);
                    }
                };
            }
            catch (NoSuchMethodException noSuchMethodException) {
                supplier = () -> {
                    throw new CodecConfigurationException(String.format("No no-args constructor for Collection class %s", clazz), noSuchMethodException);
                };
            }
            this.supplier = supplier;
        }
    }

    abstract T readValue(BsonReader var1, DecoderContext var2);

    abstract void writeValue(BsonWriter var1, T var2, EncoderContext var3);

    @Override
    public C decode(BsonReader bsonReader, DecoderContext decoderContext) {
        bsonReader.readStartArray();
        Collection collection = (Collection)this.supplier.get();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            if (bsonReader.getCurrentBsonType() == BsonType.NULL) {
                bsonReader.readNull();
                collection.add(null);
                continue;
            }
            collection.add(this.readValue(bsonReader, decoderContext));
        }
        bsonReader.readEndArray();
        return (C)collection;
    }

    @Override
    public void encode(BsonWriter bsonWriter, C c, EncoderContext encoderContext) {
        bsonWriter.writeStartArray();
        for (Object e : c) {
            if (e == null) {
                bsonWriter.writeNull();
                continue;
            }
            this.writeValue(bsonWriter, e, encoderContext);
        }
        bsonWriter.writeEndArray();
    }

    @Override
    public Class<C> getEncoderClass() {
        return this.clazz;
    }
}

