/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;

abstract class AbstractMapCodec<T, M extends Map<String, T>>
implements Codec<M> {
    private final Supplier<M> supplier;
    private final Class<M> clazz;

    AbstractMapCodec(@Nullable Class<M> clazz) {
        this.clazz = Assertions.notNull("clazz", clazz);
        Class clazz2 = clazz;
        if (clazz2 == Map.class || clazz2 == AbstractMap.class || clazz2 == HashMap.class) {
            this.supplier = () -> new HashMap();
        } else if (clazz2 == NavigableMap.class || clazz2 == TreeMap.class) {
            this.supplier = () -> new TreeMap();
        } else {
            Supplier<Map> supplier;
            try {
                Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                supplier = () -> {
                    try {
                        return (Map)constructor.newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                        throw new CodecConfigurationException("Can not invoke no-args constructor for Map class %s", reflectiveOperationException);
                    }
                };
            }
            catch (NoSuchMethodException noSuchMethodException) {
                supplier = () -> {
                    throw new CodecConfigurationException(String.format("Map class %s has no public no-args constructor", clazz), noSuchMethodException);
                };
            }
            this.supplier = supplier;
        }
    }

    abstract T readValue(BsonReader var1, DecoderContext var2);

    abstract void writeValue(BsonWriter var1, T var2, EncoderContext var3);

    @Override
    public void encode(BsonWriter bsonWriter, M m, EncoderContext encoderContext) {
        bsonWriter.writeStartDocument();
        for (Map.Entry entry : m.entrySet()) {
            bsonWriter.writeName((String)entry.getKey());
            Object v = entry.getValue();
            if (v == null) {
                bsonWriter.writeNull();
                continue;
            }
            this.writeValue(bsonWriter, v, encoderContext);
        }
        bsonWriter.writeEndDocument();
    }

    @Override
    public M decode(BsonReader bsonReader, DecoderContext decoderContext) {
        Map map = (Map)this.supplier.get();
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String string = bsonReader.readName();
            if (bsonReader.getCurrentBsonType() == BsonType.NULL) {
                bsonReader.readNull();
                map.put(string, null);
                continue;
            }
            map.put(string, this.readValue(bsonReader, decoderContext));
        }
        bsonReader.readEndDocument();
        return (M)map;
    }

    @Override
    public Class<M> getEncoderClass() {
        return this.clazz;
    }
}

