/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BinaryVector;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

final class BinaryVectorCodec
implements Codec<BinaryVector> {
    BinaryVectorCodec() {
    }

    @Override
    public void encode(BsonWriter bsonWriter, BinaryVector binaryVector, EncoderContext encoderContext) {
        bsonWriter.writeBinaryData(new BsonBinary(binaryVector));
    }

    @Override
    public BinaryVector decode(BsonReader bsonReader, DecoderContext decoderContext) {
        byte by = bsonReader.peekBinarySubType();
        if (by != BsonBinarySubType.VECTOR.getValue()) {
            throw new BsonInvalidOperationException("Expected vector binary subtype " + BsonBinarySubType.VECTOR.getValue() + " but found " + by);
        }
        return bsonReader.readBinaryData().asBinary().asVector();
    }

    @Override
    public Class<BinaryVector> getEncoderClass() {
        return BinaryVector.class;
    }
}

