/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BsonArray;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public class BsonArrayCodec
implements Codec<BsonArray> {
    private static final CodecRegistry DEFAULT_REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private static final BsonTypeCodecMap DEFAULT_BSON_TYPE_CODEC_MAP = new BsonTypeCodecMap(BsonValueCodecProvider.getBsonTypeClassMap(), DEFAULT_REGISTRY);
    private final BsonTypeCodecMap bsonTypeCodecMap;

    public BsonArrayCodec() {
        this(DEFAULT_BSON_TYPE_CODEC_MAP);
    }

    public BsonArrayCodec(CodecRegistry codecRegistry) {
        this(new BsonTypeCodecMap(BsonValueCodecProvider.getBsonTypeClassMap(), codecRegistry));
    }

    private BsonArrayCodec(BsonTypeCodecMap bsonTypeCodecMap) {
        this.bsonTypeCodecMap = Assertions.notNull("bsonTypeCodecMap", bsonTypeCodecMap);
    }

    @Override
    public BsonArray decode(BsonReader bsonReader, DecoderContext decoderContext) {
        BsonArray bsonArray = new BsonArray();
        bsonReader.readStartArray();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            bsonArray.add(this.readValue(bsonReader, decoderContext));
        }
        bsonReader.readEndArray();
        return bsonArray;
    }

    @Override
    public void encode(BsonWriter bsonWriter, BsonArray bsonArray, EncoderContext encoderContext) {
        bsonWriter.writeStartArray();
        for (BsonValue bsonValue : bsonArray) {
            Codec<?> codec = this.bsonTypeCodecMap.get(bsonValue.getBsonType());
            encoderContext.encodeWithChildContext(codec, bsonWriter, bsonValue);
        }
        bsonWriter.writeEndArray();
    }

    @Override
    public Class<BsonArray> getEncoderClass() {
        return BsonArray.class;
    }

    protected BsonValue readValue(BsonReader bsonReader, DecoderContext decoderContext) {
        BsonType bsonType = bsonReader.getCurrentBsonType();
        return (BsonValue)this.bsonTypeCodecMap.get(bsonType).decode(bsonReader, decoderContext);
    }
}

