/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public class BsonCodec
implements Codec<Bson> {
    private static final Codec<BsonDocument> BSON_DOCUMENT_CODEC = new BsonDocumentCodec();
    private final CodecRegistry registry;

    public BsonCodec(CodecRegistry codecRegistry) {
        this.registry = codecRegistry;
    }

    @Override
    public Bson decode(BsonReader bsonReader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException("The BsonCodec can only encode to Bson");
    }

    @Override
    public void encode(BsonWriter bsonWriter, Bson bson, EncoderContext encoderContext) {
        try {
            BsonDocument bsonDocument = bson.toBsonDocument(BsonDocument.class, this.registry);
            BSON_DOCUMENT_CODEC.encode(bsonWriter, bsonDocument, encoderContext);
        }
        catch (Exception exception) {
            throw new CodecConfigurationException(String.format("Unable to encode a Bson implementation: %s", bson), exception);
        }
    }

    @Override
    public Class<Bson> getEncoderClass() {
        return Bson.class;
    }
}

