/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.ObjectId;

public class BsonDocumentCodec
implements CollectibleCodec<BsonDocument> {
    private static final String ID_FIELD_NAME = "_id";
    private static final CodecRegistry DEFAULT_REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private static final BsonTypeCodecMap DEFAULT_BSON_TYPE_CODEC_MAP = new BsonTypeCodecMap(BsonValueCodecProvider.getBsonTypeClassMap(), DEFAULT_REGISTRY);
    private final CodecRegistry codecRegistry;
    private final BsonTypeCodecMap bsonTypeCodecMap;

    public BsonDocumentCodec() {
        this(DEFAULT_REGISTRY, DEFAULT_BSON_TYPE_CODEC_MAP);
    }

    public BsonDocumentCodec(CodecRegistry codecRegistry) {
        this(codecRegistry, new BsonTypeCodecMap(BsonValueCodecProvider.getBsonTypeClassMap(), codecRegistry));
    }

    private BsonDocumentCodec(CodecRegistry codecRegistry, BsonTypeCodecMap bsonTypeCodecMap) {
        this.codecRegistry = Assertions.notNull("Codec registry", codecRegistry);
        this.bsonTypeCodecMap = Assertions.notNull("bsonTypeCodecMap", bsonTypeCodecMap);
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public BsonDocument decode(BsonReader bsonReader, DecoderContext decoderContext) {
        BsonDocument bsonDocument = new BsonDocument();
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String string = bsonReader.readName();
            bsonDocument.append(string, this.readValue(bsonReader, decoderContext));
        }
        bsonReader.readEndDocument();
        return bsonDocument;
    }

    protected BsonValue readValue(BsonReader bsonReader, DecoderContext decoderContext) {
        return (BsonValue)this.bsonTypeCodecMap.get(bsonReader.getCurrentBsonType()).decode(bsonReader, decoderContext);
    }

    @Override
    public void encode(BsonWriter bsonWriter, BsonDocument bsonDocument, EncoderContext encoderContext) {
        bsonWriter.writeStartDocument();
        this.beforeFields(bsonWriter, encoderContext, bsonDocument);
        for (Map.Entry<String, BsonValue> entry : bsonDocument.entrySet()) {
            if (this.skipField(encoderContext, entry.getKey())) continue;
            bsonWriter.writeName(entry.getKey());
            this.writeValue(bsonWriter, encoderContext, entry.getValue());
        }
        bsonWriter.writeEndDocument();
    }

    private void beforeFields(BsonWriter bsonWriter, EncoderContext encoderContext, BsonDocument bsonDocument) {
        if (encoderContext.isEncodingCollectibleDocument() && bsonDocument.containsKey(ID_FIELD_NAME)) {
            bsonWriter.writeName(ID_FIELD_NAME);
            this.writeValue(bsonWriter, encoderContext, bsonDocument.get(ID_FIELD_NAME));
        }
    }

    private boolean skipField(EncoderContext encoderContext, String string) {
        return encoderContext.isEncodingCollectibleDocument() && string.equals(ID_FIELD_NAME);
    }

    private void writeValue(BsonWriter bsonWriter, EncoderContext encoderContext, BsonValue bsonValue) {
        Codec<?> codec = this.bsonTypeCodecMap.get(bsonValue.getBsonType());
        encoderContext.encodeWithChildContext(codec, bsonWriter, bsonValue);
    }

    @Override
    public Class<BsonDocument> getEncoderClass() {
        return BsonDocument.class;
    }

    @Override
    public BsonDocument generateIdIfAbsentFromDocument(BsonDocument bsonDocument) {
        if (!this.documentHasId(bsonDocument)) {
            bsonDocument.put(ID_FIELD_NAME, new BsonObjectId(new ObjectId()));
        }
        return bsonDocument;
    }

    @Override
    public boolean documentHasId(BsonDocument bsonDocument) {
        return bsonDocument.containsKey(ID_FIELD_NAME);
    }

    @Override
    public BsonValue getDocumentId(BsonDocument bsonDocument) {
        return bsonDocument.get(ID_FIELD_NAME);
    }
}

