/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;

public class BsonDocumentWrapperCodec
implements Codec<BsonDocumentWrapper> {
    private final Codec<BsonDocument> bsonDocumentCodec;

    public BsonDocumentWrapperCodec(Codec<BsonDocument> codec) {
        this.bsonDocumentCodec = codec;
    }

    @Override
    public BsonDocumentWrapper decode(BsonReader bsonReader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException("Decoding into a BsonDocumentWrapper is not allowed");
    }

    @Override
    public void encode(BsonWriter bsonWriter, BsonDocumentWrapper bsonDocumentWrapper, EncoderContext encoderContext) {
        if (bsonDocumentWrapper.isUnwrapped()) {
            this.bsonDocumentCodec.encode(bsonWriter, bsonDocumentWrapper, encoderContext);
        } else {
            Encoder encoder = bsonDocumentWrapper.getEncoder();
            encoder.encode(bsonWriter, bsonDocumentWrapper.getWrappedDocument(), encoderContext);
        }
    }

    @Override
    public Class<BsonDocumentWrapper> getEncoderClass() {
        return BsonDocumentWrapper.class;
    }
}

