/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.types.CodeWithScope;

public class CodeWithScopeCodec
implements Codec<CodeWithScope> {
    private final Codec<Document> documentCodec;

    public CodeWithScopeCodec(Codec<Document> codec) {
        this.documentCodec = codec;
    }

    @Override
    public CodeWithScope decode(BsonReader bsonReader, DecoderContext decoderContext) {
        String string = bsonReader.readJavaScriptWithScope();
        Document document = (Document)this.documentCodec.decode(bsonReader, decoderContext);
        return new CodeWithScope(string, document);
    }

    @Override
    public void encode(BsonWriter bsonWriter, CodeWithScope codeWithScope, EncoderContext encoderContext) {
        bsonWriter.writeJavaScriptWithScope(codeWithScope.getCode());
        this.documentCodec.encode(bsonWriter, codeWithScope.getScope(), encoderContext);
    }

    @Override
    public Class<CodeWithScope> getEncoderClass() {
        return CodeWithScope.class;
    }
}

