/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.util.Collection;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.Transformer;
import org.bson.UuidRepresentation;
import org.bson.assertions.Assertions;
import org.bson.codecs.AbstractCollectionCodec;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.Codec;
import org.bson.codecs.ContainerCodecHelper;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.OverridableUuidRepresentationCodec;
import org.bson.codecs.configuration.CodecRegistry;

final class CollectionCodec<C extends Collection<Object>>
extends AbstractCollectionCodec<Object, C>
implements OverridableUuidRepresentationCodec<C> {
    private final CodecRegistry registry;
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final Transformer valueTransformer;
    private final UuidRepresentation uuidRepresentation;

    CollectionCodec(CodecRegistry codecRegistry, BsonTypeClassMap bsonTypeClassMap, Transformer transformer, Class<C> clazz) {
        this(codecRegistry, new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), codecRegistry), transformer, clazz, UuidRepresentation.UNSPECIFIED);
    }

    private CollectionCodec(CodecRegistry codecRegistry, BsonTypeCodecMap bsonTypeCodecMap, Transformer transformer, Class<C> clazz, UuidRepresentation uuidRepresentation) {
        super(clazz);
        this.registry = Assertions.notNull("registry", codecRegistry);
        this.bsonTypeCodecMap = bsonTypeCodecMap;
        this.valueTransformer = transformer != null ? transformer : object -> object;
        this.uuidRepresentation = uuidRepresentation;
    }

    @Override
    public Codec<C> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        if (this.uuidRepresentation.equals((Object)uuidRepresentation)) {
            return this;
        }
        return new CollectionCodec(this.registry, this.bsonTypeCodecMap, this.valueTransformer, this.getEncoderClass(), uuidRepresentation);
    }

    @Override
    Object readValue(BsonReader bsonReader, DecoderContext decoderContext) {
        return ContainerCodecHelper.readValue(bsonReader, decoderContext, this.bsonTypeCodecMap, this.uuidRepresentation, this.registry, this.valueTransformer);
    }

    @Override
    void writeValue(BsonWriter bsonWriter, Object object, EncoderContext encoderContext) {
        Codec<?> codec = this.registry.get(object.getClass());
        encoderContext.encodeWithChildContext(codec, bsonWriter, object);
    }
}

