/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bson.Transformer;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectionCodec;
import org.bson.codecs.ContainerCodecHelper;
import org.bson.codecs.ParameterizedCollectionCodec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;

public class CollectionCodecProvider
implements CodecProvider {
    private final BsonTypeClassMap bsonTypeClassMap;
    private final Transformer valueTransformer;

    public CollectionCodecProvider() {
        this(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public CollectionCodecProvider(Transformer transformer) {
        this(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP, transformer);
    }

    public CollectionCodecProvider(BsonTypeClassMap bsonTypeClassMap) {
        this(bsonTypeClassMap, null);
    }

    public CollectionCodecProvider(BsonTypeClassMap bsonTypeClassMap, Transformer transformer) {
        this.bsonTypeClassMap = Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
        this.valueTransformer = transformer;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry codecRegistry) {
        return this.get(clazz, Collections.emptyList(), codecRegistry);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, List<Type> list, CodecRegistry codecRegistry) {
        if (Collection.class.isAssignableFrom(clazz)) {
            int n = list.size();
            switch (n) {
                case 0: {
                    CollectionCodec<T> collectionCodec = new CollectionCodec<T>(codecRegistry, this.bsonTypeClassMap, this.valueTransformer, clazz);
                    return collectionCodec;
                }
                case 1: {
                    ParameterizedCollectionCodec parameterizedCollectionCodec = new ParameterizedCollectionCodec(ContainerCodecHelper.getCodec(codecRegistry, list.get(0)), clazz);
                    return parameterizedCollectionCodec;
                }
            }
            throw new CodecConfigurationException("Expected only one type argument for a Collection, but found " + n);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CollectionCodecProvider collectionCodecProvider = (CollectionCodecProvider)object;
        if (!this.bsonTypeClassMap.equals(collectionCodecProvider.bsonTypeClassMap)) {
            return false;
        }
        return Objects.equals(this.valueTransformer, collectionCodecProvider.valueTransformer);
    }

    public int hashCode() {
        return Objects.hash(this.bsonTypeClassMap, this.valueTransformer);
    }

    public String toString() {
        return "CollectionCodecProvider{}";
    }
}

