/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.UUID;
import org.bson.BinaryVector;
import org.bson.BsonBinarySubType;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.Transformer;
import org.bson.UuidRepresentation;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.internal.UuidHelper;

final class ContainerCodecHelper {
    static Object readValue(BsonReader bsonReader, DecoderContext decoderContext, BsonTypeCodecMap bsonTypeCodecMap, UuidRepresentation uuidRepresentation, CodecRegistry codecRegistry, Transformer transformer) {
        BsonType bsonType = bsonReader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            bsonReader.readNull();
            return null;
        }
        Codec<?> codec = bsonTypeCodecMap.get(bsonType);
        if (bsonType == BsonType.BINARY) {
            byte by = bsonReader.peekBinarySubType();
            codec = ContainerCodecHelper.getBinarySubTypeCodec(bsonReader, uuidRepresentation, codecRegistry, by, codec);
        }
        return transformer.transform(codec.decode(bsonReader, decoderContext));
    }

    private static Codec<?> getBinarySubTypeCodec(BsonReader bsonReader, UuidRepresentation uuidRepresentation, CodecRegistry codecRegistry, byte by, Codec<?> codec) {
        if (by == BsonBinarySubType.VECTOR.getValue()) {
            Codec<BinaryVector> codec2 = codecRegistry.get(BinaryVector.class, codecRegistry);
            if (codec2 != null) {
                return codec2;
            }
        } else if (bsonReader.peekBinarySize() == 16) {
            switch (by) {
                case 3: {
                    if (!UuidHelper.isLegacyUUID(uuidRepresentation)) break;
                    return codecRegistry.get(UUID.class);
                }
                case 4: {
                    if (uuidRepresentation != UuidRepresentation.STANDARD) break;
                    return codecRegistry.get(UUID.class);
                }
            }
        }
        return codec;
    }

    static Codec<?> getCodec(CodecRegistry codecRegistry, Type type) {
        if (type instanceof Class) {
            return codecRegistry.get((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return codecRegistry.get((Class)parameterizedType.getRawType(), Arrays.asList(parameterizedType.getActualTypeArguments()));
        }
        throw new CodecConfigurationException("Unsupported generic type of container: " + type);
    }

    private ContainerCodecHelper() {
    }
}

