/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.util.Arrays;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.Transformer;
import org.bson.UuidRepresentation;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.CollectionCodecProvider;
import org.bson.codecs.ContainerCodecHelper;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.IdGenerator;
import org.bson.codecs.IterableCodecProvider;
import org.bson.codecs.MapCodecProvider;
import org.bson.codecs.ObjectIdGenerator;
import org.bson.codecs.OverridableUuidRepresentationCodec;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public class DocumentCodec
implements CollectibleCodec<Document>,
OverridableUuidRepresentationCodec<Document> {
    private static final String ID_FIELD_NAME = "_id";
    private static final CodecRegistry DEFAULT_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new CollectionCodecProvider(), new IterableCodecProvider(), new BsonValueCodecProvider(), new DocumentCodecProvider(), new MapCodecProvider()));
    private static final BsonTypeCodecMap DEFAULT_BSON_TYPE_CODEC_MAP = new BsonTypeCodecMap(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP, DEFAULT_REGISTRY);
    private static final IdGenerator DEFAULT_ID_GENERATOR = new ObjectIdGenerator();
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final CodecRegistry registry;
    private final IdGenerator idGenerator;
    private final Transformer valueTransformer;
    private final UuidRepresentation uuidRepresentation;

    public DocumentCodec() {
        this(DEFAULT_REGISTRY, DEFAULT_BSON_TYPE_CODEC_MAP, null);
    }

    public DocumentCodec(CodecRegistry codecRegistry) {
        this(codecRegistry, BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public DocumentCodec(CodecRegistry codecRegistry, BsonTypeClassMap bsonTypeClassMap) {
        this(codecRegistry, bsonTypeClassMap, null);
    }

    public DocumentCodec(CodecRegistry codecRegistry, BsonTypeClassMap bsonTypeClassMap, Transformer transformer) {
        this(codecRegistry, new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), codecRegistry), transformer);
    }

    private DocumentCodec(CodecRegistry codecRegistry, BsonTypeCodecMap bsonTypeCodecMap, Transformer transformer) {
        this(codecRegistry, bsonTypeCodecMap, DEFAULT_ID_GENERATOR, transformer, UuidRepresentation.UNSPECIFIED);
    }

    private DocumentCodec(CodecRegistry codecRegistry, BsonTypeCodecMap bsonTypeCodecMap, IdGenerator idGenerator, Transformer transformer, UuidRepresentation uuidRepresentation) {
        this.registry = Assertions.notNull("registry", codecRegistry);
        this.bsonTypeCodecMap = bsonTypeCodecMap;
        this.idGenerator = idGenerator;
        this.valueTransformer = transformer != null ? transformer : object -> object;
        this.uuidRepresentation = uuidRepresentation;
    }

    @Override
    public Codec<Document> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        if (this.uuidRepresentation.equals((Object)uuidRepresentation)) {
            return this;
        }
        return new DocumentCodec(this.registry, this.bsonTypeCodecMap, this.idGenerator, this.valueTransformer, uuidRepresentation);
    }

    @Override
    public boolean documentHasId(Document document) {
        return document.containsKey(ID_FIELD_NAME);
    }

    @Override
    public BsonValue getDocumentId(Document document) {
        if (!this.documentHasId(document)) {
            throw new IllegalStateException("The document does not contain an _id");
        }
        Object object = document.get(ID_FIELD_NAME);
        if (object instanceof BsonValue) {
            return (BsonValue)object;
        }
        BsonDocument bsonDocument = new BsonDocument();
        BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(bsonDocument);
        bsonDocumentWriter.writeStartDocument();
        bsonDocumentWriter.writeName(ID_FIELD_NAME);
        this.writeValue(bsonDocumentWriter, EncoderContext.builder().build(), object);
        bsonDocumentWriter.writeEndDocument();
        return bsonDocument.get(ID_FIELD_NAME);
    }

    @Override
    public Document generateIdIfAbsentFromDocument(Document document) {
        if (!this.documentHasId(document)) {
            document.put(ID_FIELD_NAME, this.idGenerator.generate());
        }
        return document;
    }

    @Override
    public void encode(BsonWriter bsonWriter, Document document, EncoderContext encoderContext) {
        bsonWriter.writeStartDocument();
        this.beforeFields(bsonWriter, encoderContext, document);
        for (Map.Entry<String, Object> entry : document.entrySet()) {
            if (this.skipField(encoderContext, entry.getKey())) continue;
            bsonWriter.writeName(entry.getKey());
            this.writeValue(bsonWriter, encoderContext, entry.getValue());
        }
        bsonWriter.writeEndDocument();
    }

    @Override
    public Document decode(BsonReader bsonReader, DecoderContext decoderContext) {
        Document document = new Document();
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String string = bsonReader.readName();
            document.put(string, ContainerCodecHelper.readValue(bsonReader, decoderContext, this.bsonTypeCodecMap, this.uuidRepresentation, this.registry, this.valueTransformer));
        }
        bsonReader.readEndDocument();
        return document;
    }

    @Override
    public Class<Document> getEncoderClass() {
        return Document.class;
    }

    private void beforeFields(BsonWriter bsonWriter, EncoderContext encoderContext, Map<String, Object> map) {
        if (encoderContext.isEncodingCollectibleDocument() && map.containsKey(ID_FIELD_NAME)) {
            bsonWriter.writeName(ID_FIELD_NAME);
            this.writeValue(bsonWriter, encoderContext, map.get(ID_FIELD_NAME));
        }
    }

    private boolean skipField(EncoderContext encoderContext, String string) {
        return encoderContext.isEncodingCollectibleDocument() && string.equals(ID_FIELD_NAME);
    }

    private void writeValue(BsonWriter bsonWriter, EncoderContext encoderContext, Object object) {
        if (object == null) {
            bsonWriter.writeNull();
        } else {
            Codec<?> codec = this.registry.get(object.getClass());
            encoderContext.encodeWithChildContext(codec, bsonWriter, object);
        }
    }
}

