/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.util.Objects;
import org.bson.Document;
import org.bson.Transformer;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.CodeWithScopeCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.CodeWithScope;

public class DocumentCodecProvider
implements CodecProvider {
    private final BsonTypeClassMap bsonTypeClassMap;
    private final Transformer valueTransformer;

    public DocumentCodecProvider() {
        this(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public DocumentCodecProvider(Transformer transformer) {
        this(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP, transformer);
    }

    public DocumentCodecProvider(BsonTypeClassMap bsonTypeClassMap) {
        this(bsonTypeClassMap, null);
    }

    public DocumentCodecProvider(BsonTypeClassMap bsonTypeClassMap, Transformer transformer) {
        this.bsonTypeClassMap = Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
        this.valueTransformer = transformer;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry codecRegistry) {
        if (clazz == CodeWithScope.class) {
            return new CodeWithScopeCodec(codecRegistry.get(Document.class));
        }
        if (clazz == Document.class) {
            return new DocumentCodec(codecRegistry, this.bsonTypeClassMap, this.valueTransformer);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DocumentCodecProvider documentCodecProvider = (DocumentCodecProvider)object;
        if (!this.bsonTypeClassMap.equals(documentCodecProvider.bsonTypeClassMap)) {
            return false;
        }
        return Objects.equals(this.valueTransformer, documentCodecProvider.valueTransformer);
    }

    public int hashCode() {
        int n = this.bsonTypeClassMap.hashCode();
        n = 31 * n + (this.valueTransformer != null ? this.valueTransformer.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "DocumentCodecProvider{}";
    }
}

