/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.Float32BinaryVector;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

final class Float32BinaryVectorCodec
implements Codec<Float32BinaryVector> {
    Float32BinaryVectorCodec() {
    }

    @Override
    public void encode(BsonWriter bsonWriter, Float32BinaryVector float32BinaryVector, EncoderContext encoderContext) {
        bsonWriter.writeBinaryData(new BsonBinary(float32BinaryVector));
    }

    @Override
    public Float32BinaryVector decode(BsonReader bsonReader, DecoderContext decoderContext) {
        byte by = bsonReader.peekBinarySubType();
        if (by != BsonBinarySubType.VECTOR.getValue()) {
            throw new BsonInvalidOperationException("Expected vector binary subtype " + BsonBinarySubType.VECTOR.getValue() + " but found: " + by);
        }
        return bsonReader.readBinaryData().asBinary().asVector().asFloat32Vector();
    }

    @Override
    public Class<Float32BinaryVector> getEncoderClass() {
        return Float32BinaryVector.class;
    }
}

