/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.Int8BinaryVector;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

final class Int8VectorCodec
implements Codec<Int8BinaryVector> {
    Int8VectorCodec() {
    }

    @Override
    public void encode(BsonWriter bsonWriter, Int8BinaryVector int8BinaryVector, EncoderContext encoderContext) {
        bsonWriter.writeBinaryData(new BsonBinary(int8BinaryVector));
    }

    @Override
    public Int8BinaryVector decode(BsonReader bsonReader, DecoderContext decoderContext) {
        byte by = bsonReader.peekBinarySubType();
        if (by != BsonBinarySubType.VECTOR.getValue()) {
            throw new BsonInvalidOperationException("Expected vector binary subtype " + BsonBinarySubType.VECTOR.getValue() + " but found: " + by);
        }
        return bsonReader.readBinaryData().asBinary().asVector().asInt8Vector();
    }

    @Override
    public Class<Int8BinaryVector> getEncoderClass() {
        return Int8BinaryVector.class;
    }
}

