/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.util.Objects;
import org.bson.Transformer;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.Codec;
import org.bson.codecs.IterableCodec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;

public class IterableCodecProvider
implements CodecProvider {
    private final BsonTypeClassMap bsonTypeClassMap;
    private final Transformer valueTransformer;

    public IterableCodecProvider() {
        this(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public IterableCodecProvider(Transformer transformer) {
        this(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP, transformer);
    }

    public IterableCodecProvider(BsonTypeClassMap bsonTypeClassMap) {
        this(bsonTypeClassMap, null);
    }

    public IterableCodecProvider(BsonTypeClassMap bsonTypeClassMap, Transformer transformer) {
        this.bsonTypeClassMap = Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
        this.valueTransformer = transformer;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry codecRegistry) {
        if (Iterable.class.isAssignableFrom(clazz)) {
            return new IterableCodec(codecRegistry, this.bsonTypeClassMap, this.valueTransformer);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IterableCodecProvider iterableCodecProvider = (IterableCodecProvider)object;
        if (!this.bsonTypeClassMap.equals(iterableCodecProvider.bsonTypeClassMap)) {
            return false;
        }
        return Objects.equals(this.valueTransformer, iterableCodecProvider.valueTransformer);
    }

    public int hashCode() {
        int n = this.bsonTypeClassMap.hashCode();
        n = 31 * n + (this.valueTransformer != null ? this.valueTransformer.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "IterableCodecProvider{}";
    }
}

