/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.io.StringWriter;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.json.JsonObject;
import org.bson.json.JsonReader;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;

public class JsonObjectCodec
implements Codec<JsonObject> {
    private final JsonWriterSettings writerSettings;

    public JsonObjectCodec() {
        this(JsonWriterSettings.builder().build());
    }

    public JsonObjectCodec(JsonWriterSettings jsonWriterSettings) {
        this.writerSettings = jsonWriterSettings;
    }

    @Override
    public void encode(BsonWriter bsonWriter, JsonObject jsonObject, EncoderContext encoderContext) {
        bsonWriter.pipe(new JsonReader(jsonObject.getJson()));
    }

    @Override
    public JsonObject decode(BsonReader bsonReader, DecoderContext decoderContext) {
        StringWriter stringWriter = new StringWriter();
        new JsonWriter(stringWriter, this.writerSettings).pipe(bsonReader);
        return new JsonObject(stringWriter.toString());
    }

    @Override
    public Class<JsonObject> getEncoderClass() {
        return JsonObject.class;
    }
}

