/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.Transformer;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.Codec;
import org.bson.codecs.ContainerCodecHelper;
import org.bson.codecs.MapCodec;
import org.bson.codecs.ParameterizedMapCodec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;

public class MapCodecProvider
implements CodecProvider {
    private final BsonTypeClassMap bsonTypeClassMap;
    private final Transformer valueTransformer;

    public MapCodecProvider() {
        this(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public MapCodecProvider(BsonTypeClassMap bsonTypeClassMap) {
        this(bsonTypeClassMap, null);
    }

    public MapCodecProvider(Transformer transformer) {
        this(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP, transformer);
    }

    public MapCodecProvider(BsonTypeClassMap bsonTypeClassMap, Transformer transformer) {
        this.bsonTypeClassMap = Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
        this.valueTransformer = transformer;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry codecRegistry) {
        return this.get(clazz, Collections.emptyList(), codecRegistry);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, List<Type> list, CodecRegistry codecRegistry) {
        if (Map.class.isAssignableFrom(clazz)) {
            int n = list.size();
            switch (n) {
                case 0: {
                    MapCodec<T> mapCodec = new MapCodec<T>(codecRegistry, this.bsonTypeClassMap, this.valueTransformer, clazz);
                    return mapCodec;
                }
                case 2: {
                    Type type = list.get(0);
                    if (!type.getTypeName().equals("java.lang.String")) {
                        throw new CodecConfigurationException("Unsupported key type for Map: " + type.getTypeName());
                    }
                    ParameterizedMapCodec parameterizedMapCodec = new ParameterizedMapCodec(ContainerCodecHelper.getCodec(codecRegistry, list.get(1)), clazz);
                    return parameterizedMapCodec;
                }
            }
            throw new CodecConfigurationException("Expected two parameterized type for an Iterable, but found " + n);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MapCodecProvider mapCodecProvider = (MapCodecProvider)object;
        if (!this.bsonTypeClassMap.equals(mapCodecProvider.bsonTypeClassMap)) {
            return false;
        }
        return Objects.equals(this.valueTransformer, mapCodecProvider.valueTransformer);
    }

    public int hashCode() {
        int n = this.bsonTypeClassMap.hashCode();
        n = 31 * n + (this.valueTransformer != null ? this.valueTransformer.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "MapCodecProvider{}";
    }
}

