/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.PackedBitBinaryVector;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

final class PackedBitBinaryVectorCodec
implements Codec<PackedBitBinaryVector> {
    PackedBitBinaryVectorCodec() {
    }

    @Override
    public void encode(BsonWriter bsonWriter, PackedBitBinaryVector packedBitBinaryVector, EncoderContext encoderContext) {
        bsonWriter.writeBinaryData(new BsonBinary(packedBitBinaryVector));
    }

    @Override
    public PackedBitBinaryVector decode(BsonReader bsonReader, DecoderContext decoderContext) {
        byte by = bsonReader.peekBinarySubType();
        if (by != BsonBinarySubType.VECTOR.getValue()) {
            throw new BsonInvalidOperationException("Expected vector binary subtype " + BsonBinarySubType.VECTOR.getValue() + " but found: " + by);
        }
        return bsonReader.readBinaryData().asBinary().asVector().asPackedBitVector();
    }

    @Override
    public Class<PackedBitBinaryVector> getEncoderClass() {
        return PackedBitBinaryVector.class;
    }
}

