/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class PatternCodec
implements Codec<Pattern> {
    private static final int GLOBAL_FLAG = 256;

    @Override
    public void encode(BsonWriter bsonWriter, Pattern pattern, EncoderContext encoderContext) {
        bsonWriter.writeRegularExpression(new BsonRegularExpression(pattern.pattern(), PatternCodec.getOptionsAsString(pattern)));
    }

    @Override
    public Pattern decode(BsonReader bsonReader, DecoderContext decoderContext) {
        BsonRegularExpression bsonRegularExpression = bsonReader.readRegularExpression();
        return Pattern.compile(bsonRegularExpression.getPattern(), PatternCodec.getOptionsAsInt(bsonRegularExpression));
    }

    @Override
    public Class<Pattern> getEncoderClass() {
        return Pattern.class;
    }

    private static String getOptionsAsString(Pattern pattern) {
        int n = pattern.flags();
        StringBuilder stringBuilder = new StringBuilder();
        for (RegexFlag regexFlag : RegexFlag.values()) {
            if ((pattern.flags() & regexFlag.javaFlag) <= 0) continue;
            stringBuilder.append(regexFlag.flagChar);
            n -= regexFlag.javaFlag;
        }
        if (n > 0) {
            throw new IllegalArgumentException("some flags could not be recognized.");
        }
        return stringBuilder.toString();
    }

    private static int getOptionsAsInt(BsonRegularExpression bsonRegularExpression) {
        int n = 0;
        String string = bsonRegularExpression.getOptions();
        if (string == null || string.length() == 0) {
            return n;
        }
        string = string.toLowerCase();
        for (int i = 0; i < string.length(); ++i) {
            RegexFlag regexFlag = RegexFlag.getByCharacter(string.charAt(i));
            if (regexFlag != null) {
                n |= regexFlag.javaFlag;
                if (regexFlag.unsupported == null) continue;
                continue;
            }
            throw new IllegalArgumentException("unrecognized flag [" + string.charAt(i) + "] " + string.charAt(i));
        }
        return n;
    }

    private static enum RegexFlag {
        CANON_EQ(128, 'c', "Pattern.CANON_EQ"),
        UNIX_LINES(1, 'd', "Pattern.UNIX_LINES"),
        GLOBAL(256, 'g', null),
        CASE_INSENSITIVE(2, 'i', null),
        MULTILINE(8, 'm', null),
        DOTALL(32, 's', "Pattern.DOTALL"),
        LITERAL(16, 't', "Pattern.LITERAL"),
        UNICODE_CASE(64, 'u', "Pattern.UNICODE_CASE"),
        COMMENTS(4, 'x', null);

        private static final Map<Character, RegexFlag> BY_CHARACTER;
        private final int javaFlag;
        private final char flagChar;
        private final String unsupported;

        public static RegexFlag getByCharacter(char c) {
            return BY_CHARACTER.get(Character.valueOf(c));
        }

        private RegexFlag(int n2, char c, String string2) {
            this.javaFlag = n2;
            this.flagChar = c;
            this.unsupported = string2;
        }

        static {
            BY_CHARACTER = new HashMap<Character, RegexFlag>();
            for (RegexFlag regexFlag : RegexFlag.values()) {
                BY_CHARACTER.put(Character.valueOf(regexFlag.flagChar), regexFlag);
            }
        }
    }
}

