/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.RawBsonDocument;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.ByteBufferBsonInput;

public class RawBsonDocumentCodec
implements Codec<RawBsonDocument> {
    @Override
    public void encode(BsonWriter bsonWriter, RawBsonDocument rawBsonDocument, EncoderContext encoderContext) {
        try (BsonBinaryReader bsonBinaryReader = new BsonBinaryReader(new ByteBufferBsonInput(rawBsonDocument.getByteBuffer()));){
            bsonWriter.pipe(bsonBinaryReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawBsonDocument decode(BsonReader bsonReader, DecoderContext decoderContext) {
        BasicOutputBuffer basicOutputBuffer = new BasicOutputBuffer(0);
        BsonBinaryWriter bsonBinaryWriter = new BsonBinaryWriter(basicOutputBuffer);
        try {
            bsonBinaryWriter.pipe(bsonReader);
            RawBsonDocument rawBsonDocument = new RawBsonDocument(basicOutputBuffer.getInternalBuffer(), 0, basicOutputBuffer.getPosition());
            return rawBsonDocument;
        }
        finally {
            bsonBinaryWriter.close();
            basicOutputBuffer.close();
        }
    }

    @Override
    public Class<RawBsonDocument> getEncoderClass() {
        return RawBsonDocument.class;
    }
}

