/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.RepresentationConfigurable;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.types.ObjectId;

public class StringCodec
implements Codec<String>,
RepresentationConfigurable<String> {
    private final BsonType representation;

    public StringCodec() {
        this.representation = BsonType.STRING;
    }

    private StringCodec(BsonType bsonType) {
        this.representation = bsonType;
    }

    @Override
    public BsonType getRepresentation() {
        return this.representation;
    }

    @Override
    public Codec<String> withRepresentation(BsonType bsonType) {
        if (bsonType != BsonType.OBJECT_ID && bsonType != BsonType.STRING) {
            throw new CodecConfigurationException((Object)((Object)bsonType) + " is not a supported representation for StringCodec");
        }
        return new StringCodec(bsonType);
    }

    @Override
    public void encode(BsonWriter bsonWriter, String string, EncoderContext encoderContext) {
        switch (this.representation) {
            case STRING: {
                bsonWriter.writeString(string);
                break;
            }
            case OBJECT_ID: {
                bsonWriter.writeObjectId(new ObjectId(string));
                break;
            }
            default: {
                throw new BsonInvalidOperationException("Cannot encode a String to a " + (Object)((Object)this.representation));
            }
        }
    }

    @Override
    public String decode(BsonReader bsonReader, DecoderContext decoderContext) {
        switch (this.representation) {
            case STRING: {
                if (bsonReader.getCurrentBsonType() == BsonType.SYMBOL) {
                    return bsonReader.readSymbol();
                }
                return bsonReader.readString();
            }
            case OBJECT_ID: {
                return bsonReader.readObjectId().toHexString();
            }
        }
        throw new CodecConfigurationException("Cannot decode " + (Object)((Object)this.representation) + " to a String");
    }

    @Override
    public Class<String> getEncoderClass() {
        return String.class;
    }
}

