/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.util.UUID;
import org.bson.BSONException;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.UuidRepresentation;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.internal.UuidHelper;

public class UuidCodec
implements Codec<UUID> {
    private final UuidRepresentation uuidRepresentation;

    public UuidCodec(UuidRepresentation uuidRepresentation) {
        Assertions.notNull("uuidRepresentation", uuidRepresentation);
        this.uuidRepresentation = uuidRepresentation;
    }

    public UuidCodec() {
        this.uuidRepresentation = UuidRepresentation.UNSPECIFIED;
    }

    public UuidRepresentation getUuidRepresentation() {
        return this.uuidRepresentation;
    }

    @Override
    public void encode(BsonWriter bsonWriter, UUID uUID, EncoderContext encoderContext) {
        if (this.uuidRepresentation == UuidRepresentation.UNSPECIFIED) {
            throw new CodecConfigurationException("The uuidRepresentation has not been specified, so the UUID cannot be encoded.");
        }
        byte[] byArray = UuidHelper.encodeUuidToBinary(uUID, this.uuidRepresentation);
        if (this.uuidRepresentation == UuidRepresentation.STANDARD) {
            bsonWriter.writeBinaryData(new BsonBinary(BsonBinarySubType.UUID_STANDARD, byArray));
        } else {
            bsonWriter.writeBinaryData(new BsonBinary(BsonBinarySubType.UUID_LEGACY, byArray));
        }
    }

    @Override
    public UUID decode(BsonReader bsonReader, DecoderContext decoderContext) {
        byte by = bsonReader.peekBinarySubType();
        if (by != BsonBinarySubType.UUID_LEGACY.getValue() && by != BsonBinarySubType.UUID_STANDARD.getValue()) {
            throw new BSONException("Unexpected BsonBinarySubType");
        }
        byte[] byArray = bsonReader.readBinaryData().getData();
        return UuidHelper.decodeBinaryToUuid(byArray, by, this.uuidRepresentation);
    }

    @Override
    public Class<UUID> getEncoderClass() {
        return UUID.class;
    }

    public String toString() {
        return "UuidCodec{uuidRepresentation=" + (Object)((Object)this.uuidRepresentation) + '}';
    }
}

