/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.configuration;

import java.util.Arrays;
import java.util.List;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.configuration.MapOfCodecsProvider;
import org.bson.codecs.configuration.OverridableUuidRepresentationCodecProvider;
import org.bson.internal.ProvidersCodecRegistry;

public final class CodecRegistries {
    public static CodecRegistry withUuidRepresentation(CodecRegistry codecRegistry, UuidRepresentation uuidRepresentation) {
        return CodecRegistries.fromProviders(new OverridableUuidRepresentationCodecProvider(codecRegistry, uuidRepresentation));
    }

    public static CodecRegistry fromCodecs(Codec<?> ... codecArray) {
        return CodecRegistries.fromCodecs(Arrays.asList(codecArray));
    }

    public static CodecRegistry fromCodecs(List<? extends Codec<?>> list) {
        return CodecRegistries.fromProviders(new MapOfCodecsProvider(list));
    }

    public static CodecRegistry fromProviders(CodecProvider ... codecProviderArray) {
        return CodecRegistries.fromProviders(Arrays.asList(codecProviderArray));
    }

    public static CodecRegistry fromProviders(List<? extends CodecProvider> list) {
        return new ProvidersCodecRegistry(list);
    }

    public static CodecRegistry fromRegistries(CodecRegistry ... codecRegistryArray) {
        return CodecRegistries.fromRegistries(Arrays.asList(codecRegistryArray));
    }

    public static CodecRegistry fromRegistries(List<? extends CodecRegistry> list) {
        return new ProvidersCodecRegistry(list);
    }

    private CodecRegistries() {
    }
}

