/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.configuration;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.bson.UuidRepresentation;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.OverridableUuidRepresentationCodec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;

final class OverridableUuidRepresentationCodecProvider
implements CodecProvider {
    private final CodecProvider wrapped;
    private final UuidRepresentation uuidRepresentation;

    OverridableUuidRepresentationCodecProvider(CodecProvider codecProvider, UuidRepresentation uuidRepresentation) {
        this.uuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
        this.wrapped = Assertions.notNull("wrapped", codecProvider);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry codecRegistry) {
        return this.get(clazz, Collections.emptyList(), codecRegistry);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, List<Type> list, CodecRegistry codecRegistry) {
        Codec<T> codec = this.wrapped.get(clazz, list, codecRegistry);
        if (codec instanceof OverridableUuidRepresentationCodec) {
            Codec codec2 = ((OverridableUuidRepresentationCodec)((Object)codec)).withUuidRepresentation(this.uuidRepresentation);
            codec = codec2;
        }
        return codec;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OverridableUuidRepresentationCodecProvider overridableUuidRepresentationCodecProvider = (OverridableUuidRepresentationCodecProvider)object;
        if (!this.wrapped.equals(overridableUuidRepresentationCodecProvider.wrapped)) {
            return false;
        }
        return this.uuidRepresentation == overridableUuidRepresentationCodecProvider.uuidRepresentation;
    }

    public int hashCode() {
        int n = this.wrapped.hashCode();
        n = 31 * n + this.uuidRepresentation.hashCode();
        return n;
    }

    public String toString() {
        return "OverridableUuidRepresentationCodecRegistry{wrapped=" + this.wrapped + ", uuidRepresentation=" + (Object)((Object)this.uuidRepresentation) + '}';
    }
}

