/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.jsr310;

import java.time.Instant;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.jsr310.DateTimeBasedCodec;

public class InstantCodec
extends DateTimeBasedCodec<Instant> {
    @Override
    public Instant decode(BsonReader bsonReader, DecoderContext decoderContext) {
        return Instant.ofEpochMilli(this.validateAndReadDateTime(bsonReader));
    }

    @Override
    public void encode(BsonWriter bsonWriter, Instant instant, EncoderContext encoderContext) {
        try {
            bsonWriter.writeDateTime(instant.toEpochMilli());
        }
        catch (ArithmeticException arithmeticException) {
            throw new CodecConfigurationException(String.format("Unsupported Instant value '%s' could not be converted to milliseconds: %s", instant, arithmeticException.getMessage()), arithmeticException);
        }
    }

    @Override
    public Class<Instant> getEncoderClass() {
        return Instant.class;
    }
}

