/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.jsr310;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.jsr310.DateTimeBasedCodec;

public class LocalDateTimeCodec
extends DateTimeBasedCodec<LocalDateTime> {
    @Override
    public LocalDateTime decode(BsonReader bsonReader, DecoderContext decoderContext) {
        return Instant.ofEpochMilli(this.validateAndReadDateTime(bsonReader)).atZone(ZoneOffset.UTC).toLocalDateTime();
    }

    @Override
    public void encode(BsonWriter bsonWriter, LocalDateTime localDateTime, EncoderContext encoderContext) {
        try {
            bsonWriter.writeDateTime(localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        catch (ArithmeticException arithmeticException) {
            throw new CodecConfigurationException(String.format("Unsupported LocalDateTime value '%s' could not be converted to milliseconds: %s", localDateTime, arithmeticException.getMessage()), arithmeticException);
        }
    }

    @Override
    public Class<LocalDateTime> getEncoderClass() {
        return LocalDateTime.class;
    }
}

