/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.codecs.pojo.ClassModelBuilder;
import org.bson.codecs.pojo.IdPropertyModelHolder;
import org.bson.codecs.pojo.InstanceCreator;
import org.bson.codecs.pojo.InstanceCreatorFactory;
import org.bson.codecs.pojo.PropertyModel;
import org.bson.codecs.pojo.TypeParameterMap;

public final class ClassModel<T> {
    private final String name;
    private final Class<T> type;
    private final boolean hasTypeParameters;
    private final InstanceCreatorFactory<T> instanceCreatorFactory;
    private final boolean discriminatorEnabled;
    private final String discriminatorKey;
    private final String discriminator;
    private final IdPropertyModelHolder<?> idPropertyModelHolder;
    private final List<PropertyModel<?>> propertyModels;
    private final Map<String, TypeParameterMap> propertyNameToTypeParameterMap;

    ClassModel(Class<T> clazz, Map<String, TypeParameterMap> map, InstanceCreatorFactory<T> instanceCreatorFactory, Boolean bl, String string, String string2, IdPropertyModelHolder<?> idPropertyModelHolder, List<PropertyModel<?>> list) {
        this.name = clazz.getSimpleName();
        this.type = clazz;
        this.hasTypeParameters = clazz.getTypeParameters().length > 0;
        this.propertyNameToTypeParameterMap = Collections.unmodifiableMap(new HashMap<String, TypeParameterMap>(map));
        this.instanceCreatorFactory = instanceCreatorFactory;
        this.discriminatorEnabled = bl;
        this.discriminatorKey = string;
        this.discriminator = string2;
        this.idPropertyModelHolder = idPropertyModelHolder;
        this.propertyModels = Collections.unmodifiableList(new ArrayList(list));
    }

    public static <S> ClassModelBuilder<S> builder(Class<S> clazz) {
        return new ClassModelBuilder<S>(clazz);
    }

    InstanceCreator<T> getInstanceCreator() {
        return this.instanceCreatorFactory.create();
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean hasTypeParameters() {
        return this.hasTypeParameters;
    }

    public boolean useDiscriminator() {
        return this.discriminatorEnabled;
    }

    public String getDiscriminatorKey() {
        return this.discriminatorKey;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public PropertyModel<?> getPropertyModel(String string) {
        for (PropertyModel<?> propertyModel : this.propertyModels) {
            if (!propertyModel.getName().equals(string)) continue;
            return propertyModel;
        }
        return null;
    }

    public List<PropertyModel<?>> getPropertyModels() {
        return this.propertyModels;
    }

    public PropertyModel<?> getIdPropertyModel() {
        return this.idPropertyModelHolder != null ? this.idPropertyModelHolder.getPropertyModel() : null;
    }

    IdPropertyModelHolder<?> getIdPropertyModelHolder() {
        return this.idPropertyModelHolder;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ClassModel{type=" + this.type + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClassModel classModel = (ClassModel)object;
        if (this.discriminatorEnabled != classModel.discriminatorEnabled) {
            return false;
        }
        if (!this.getType().equals(classModel.getType())) {
            return false;
        }
        if (!this.getInstanceCreatorFactory().equals(classModel.getInstanceCreatorFactory())) {
            return false;
        }
        if (this.getDiscriminatorKey() != null ? !this.getDiscriminatorKey().equals(classModel.getDiscriminatorKey()) : classModel.getDiscriminatorKey() != null) {
            return false;
        }
        if (this.getDiscriminator() != null ? !this.getDiscriminator().equals(classModel.getDiscriminator()) : classModel.getDiscriminator() != null) {
            return false;
        }
        if (!Objects.equals(this.idPropertyModelHolder, classModel.idPropertyModelHolder)) {
            return false;
        }
        if (!this.getPropertyModels().equals(classModel.getPropertyModels())) {
            return false;
        }
        return this.getPropertyNameToTypeParameterMap().equals(classModel.getPropertyNameToTypeParameterMap());
    }

    public int hashCode() {
        int n = this.getType().hashCode();
        n = 31 * n + this.getInstanceCreatorFactory().hashCode();
        n = 31 * n + (this.discriminatorEnabled ? 1 : 0);
        n = 31 * n + (this.getDiscriminatorKey() != null ? this.getDiscriminatorKey().hashCode() : 0);
        n = 31 * n + (this.getDiscriminator() != null ? this.getDiscriminator().hashCode() : 0);
        n = 31 * n + (this.getIdPropertyModelHolder() != null ? this.getIdPropertyModelHolder().hashCode() : 0);
        n = 31 * n + this.getPropertyModels().hashCode();
        n = 31 * n + this.getPropertyNameToTypeParameterMap().hashCode();
        return n;
    }

    InstanceCreatorFactory<T> getInstanceCreatorFactory() {
        return this.instanceCreatorFactory;
    }

    Map<String, TypeParameterMap> getPropertyNameToTypeParameterMap() {
        return this.propertyNameToTypeParameterMap;
    }
}

