/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.ClassModel;
import org.bson.codecs.pojo.Convention;
import org.bson.codecs.pojo.Conventions;
import org.bson.codecs.pojo.IdGenerator;
import org.bson.codecs.pojo.IdPropertyModelHolder;
import org.bson.codecs.pojo.InstanceCreatorFactory;
import org.bson.codecs.pojo.PojoBuilderHelper;
import org.bson.codecs.pojo.PropertyModel;
import org.bson.codecs.pojo.PropertyModelBuilder;
import org.bson.codecs.pojo.TypeParameterMap;

public class ClassModelBuilder<T> {
    static final String ID_PROPERTY_NAME = "_id";
    private final List<PropertyModelBuilder<?>> propertyModelBuilders = new ArrayList();
    private IdGenerator<?> idGenerator;
    private InstanceCreatorFactory<T> instanceCreatorFactory;
    private Class<T> type;
    private Map<String, TypeParameterMap> propertyNameToTypeParameterMap = Collections.emptyMap();
    private List<Convention> conventions = Conventions.DEFAULT_CONVENTIONS;
    private List<Annotation> annotations = Collections.emptyList();
    private boolean discriminatorEnabled;
    private String discriminator;
    private String discriminatorKey;
    private String idPropertyName;

    ClassModelBuilder(Class<T> clazz) {
        PojoBuilderHelper.configureClassModelBuilder(this, Assertions.notNull("type", clazz));
    }

    public ClassModelBuilder<T> idGenerator(IdGenerator<?> idGenerator) {
        this.idGenerator = idGenerator;
        return this;
    }

    public IdGenerator<?> getIdGenerator() {
        return this.idGenerator;
    }

    public ClassModelBuilder<T> instanceCreatorFactory(InstanceCreatorFactory<T> instanceCreatorFactory) {
        this.instanceCreatorFactory = Assertions.notNull("instanceCreatorFactory", instanceCreatorFactory);
        return this;
    }

    public InstanceCreatorFactory<T> getInstanceCreatorFactory() {
        return this.instanceCreatorFactory;
    }

    public ClassModelBuilder<T> type(Class<T> clazz) {
        this.type = Assertions.notNull("type", clazz);
        return this;
    }

    public Class<T> getType() {
        return this.type;
    }

    public ClassModelBuilder<T> conventions(List<Convention> list) {
        this.conventions = Assertions.notNull("conventions", list);
        return this;
    }

    public List<Convention> getConventions() {
        return this.conventions;
    }

    public ClassModelBuilder<T> annotations(List<Annotation> list) {
        this.annotations = Assertions.notNull("annotations", list);
        return this;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public ClassModelBuilder<T> discriminator(String string) {
        this.discriminator = string;
        return this;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public ClassModelBuilder<T> discriminatorKey(String string) {
        this.discriminatorKey = string;
        return this;
    }

    public String getDiscriminatorKey() {
        return this.discriminatorKey;
    }

    public ClassModelBuilder<T> enableDiscriminator(boolean bl) {
        this.discriminatorEnabled = bl;
        return this;
    }

    public Boolean useDiscriminator() {
        return this.discriminatorEnabled;
    }

    public ClassModelBuilder<T> idPropertyName(String string) {
        this.idPropertyName = string;
        return this;
    }

    public String getIdPropertyName() {
        return this.idPropertyName;
    }

    public boolean removeProperty(String string) {
        return this.propertyModelBuilders.remove(this.getProperty(Assertions.notNull("propertyName", string)));
    }

    public PropertyModelBuilder<?> getProperty(String string) {
        Assertions.notNull("propertyName", string);
        for (PropertyModelBuilder<?> propertyModelBuilder : this.propertyModelBuilders) {
            if (!propertyModelBuilder.getName().equals(string)) continue;
            return propertyModelBuilder;
        }
        return null;
    }

    public List<PropertyModelBuilder<?>> getPropertyModelBuilders() {
        return Collections.unmodifiableList(this.propertyModelBuilders);
    }

    public ClassModel<T> build() {
        ArrayList arrayList = new ArrayList();
        PropertyModel propertyModel = null;
        PojoBuilderHelper.stateNotNull("type", this.type);
        for (Convention object : this.conventions) {
            object.apply(this);
        }
        PojoBuilderHelper.stateNotNull("instanceCreatorFactory", this.instanceCreatorFactory);
        if (this.discriminatorEnabled) {
            PojoBuilderHelper.stateNotNull("discriminatorKey", this.discriminatorKey);
            PojoBuilderHelper.stateNotNull("discriminator", this.discriminator);
        }
        for (PropertyModelBuilder propertyModelBuilder : this.propertyModelBuilders) {
            boolean bl = propertyModelBuilder.getName().equals(this.idPropertyName);
            if (bl) {
                propertyModelBuilder.readName(ID_PROPERTY_NAME).writeName(ID_PROPERTY_NAME);
            }
            PropertyModel propertyModel2 = propertyModelBuilder.build();
            arrayList.add(propertyModel2);
            if (!bl) continue;
            propertyModel = propertyModel2;
        }
        this.validatePropertyModels(this.type.getSimpleName(), arrayList);
        return new ClassModel<T>(this.type, this.propertyNameToTypeParameterMap, this.instanceCreatorFactory, this.discriminatorEnabled, this.discriminatorKey, this.discriminator, IdPropertyModelHolder.create(this.type, propertyModel, this.idGenerator), Collections.unmodifiableList(arrayList));
    }

    public String toString() {
        return String.format("ClassModelBuilder{type=%s}", this.type);
    }

    Map<String, TypeParameterMap> getPropertyNameToTypeParameterMap() {
        return this.propertyNameToTypeParameterMap;
    }

    ClassModelBuilder<T> propertyNameToTypeParameterMap(Map<String, TypeParameterMap> map) {
        this.propertyNameToTypeParameterMap = Collections.unmodifiableMap(new HashMap<String, TypeParameterMap>(map));
        return this;
    }

    ClassModelBuilder<T> addProperty(PropertyModelBuilder<?> propertyModelBuilder) {
        this.propertyModelBuilders.add(Assertions.notNull("propertyModelBuilder", propertyModelBuilder));
        return this;
    }

    private void validatePropertyModels(String string, List<PropertyModel<?>> list) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        HashMap<String, Integer> hashMap3 = new HashMap<String, Integer>();
        for (PropertyModel<?> propertyModel : list) {
            if (propertyModel.hasError()) {
                throw new CodecConfigurationException(propertyModel.getError());
            }
            this.checkForDuplicates("property", propertyModel.getName(), hashMap, string);
            if (propertyModel.isReadable()) {
                this.checkForDuplicates("read property", propertyModel.getReadName(), hashMap2, string);
            }
            if (!propertyModel.isWritable()) continue;
            this.checkForDuplicates("write property", propertyModel.getWriteName(), hashMap3, string);
        }
        if (this.idPropertyName != null && !hashMap.containsKey(this.idPropertyName)) {
            throw new CodecConfigurationException(String.format("Invalid id property, property named '%s' can not be found.", this.idPropertyName));
        }
    }

    private void checkForDuplicates(String string, String string2, Map<String, Integer> map, String string3) {
        if (map.containsKey(string2)) {
            throw new CodecConfigurationException(String.format("Duplicate %s named '%s' found in %s.", string, string2, string3));
        }
        map.put(string2, 1);
    }
}

