/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.PropertyCodecProvider;
import org.bson.codecs.pojo.PropertyCodecRegistry;
import org.bson.codecs.pojo.TypeWithTypeParameters;

final class CollectionPropertyCodecProvider
implements PropertyCodecProvider {
    CollectionPropertyCodecProvider() {
    }

    @Override
    public <T> Codec<T> get(TypeWithTypeParameters<T> typeWithTypeParameters, PropertyCodecRegistry propertyCodecRegistry) {
        if (Collection.class.isAssignableFrom(typeWithTypeParameters.getType()) && typeWithTypeParameters.getTypeParameters().size() == 1) {
            return new CollectionCodec(typeWithTypeParameters.getType(), propertyCodecRegistry.get(typeWithTypeParameters.getTypeParameters().get(0)));
        }
        return null;
    }

    private static class CollectionCodec<T>
    implements Codec<Collection<T>> {
        private final Class<Collection<T>> encoderClass;
        private final Codec<T> codec;

        CollectionCodec(Class<Collection<T>> clazz, Codec<T> codec) {
            this.encoderClass = clazz;
            this.codec = codec;
        }

        @Override
        public void encode(BsonWriter bsonWriter, Collection<T> collection, EncoderContext encoderContext) {
            bsonWriter.writeStartArray();
            for (T t : collection) {
                if (t == null) {
                    bsonWriter.writeNull();
                    continue;
                }
                this.codec.encode(bsonWriter, t, encoderContext);
            }
            bsonWriter.writeEndArray();
        }

        @Override
        public Collection<T> decode(BsonReader bsonReader, DecoderContext decoderContext) {
            Collection<T> collection = this.getInstance();
            bsonReader.readStartArray();
            while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                if (bsonReader.getCurrentBsonType() == BsonType.NULL) {
                    collection.add(null);
                    bsonReader.readNull();
                    continue;
                }
                collection.add(this.codec.decode(bsonReader, decoderContext));
            }
            bsonReader.readEndArray();
            return collection;
        }

        @Override
        public Class<Collection<T>> getEncoderClass() {
            return this.encoderClass;
        }

        private Collection<T> getInstance() {
            if (this.encoderClass.isInterface()) {
                if (this.encoderClass.isAssignableFrom(ArrayList.class)) {
                    return new ArrayList();
                }
                if (this.encoderClass.isAssignableFrom(HashSet.class)) {
                    return new HashSet();
                }
                if (this.encoderClass.isAssignableFrom(TreeSet.class)) {
                    return new TreeSet();
                }
                throw new CodecConfigurationException(String.format("Unsupported Collection interface of %s!", this.encoderClass.getName()));
            }
            try {
                return this.encoderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new CodecConfigurationException(exception.getMessage(), exception);
            }
        }
    }
}

