/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bson.BsonType;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.ClassModelBuilder;
import org.bson.codecs.pojo.Convention;
import org.bson.codecs.pojo.CreatorExecutable;
import org.bson.codecs.pojo.FieldPropertyAccessor;
import org.bson.codecs.pojo.InstanceCreatorFactoryImpl;
import org.bson.codecs.pojo.PojoBuilderHelper;
import org.bson.codecs.pojo.PropertyAccessor;
import org.bson.codecs.pojo.PropertyAccessorImpl;
import org.bson.codecs.pojo.PropertyMetadata;
import org.bson.codecs.pojo.PropertyModelBuilder;
import org.bson.codecs.pojo.PropertyModelSerializationInlineImpl;
import org.bson.codecs.pojo.TypeData;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonDiscriminator;
import org.bson.codecs.pojo.annotations.BsonExtraElements;
import org.bson.codecs.pojo.annotations.BsonId;
import org.bson.codecs.pojo.annotations.BsonIgnore;
import org.bson.codecs.pojo.annotations.BsonProperty;
import org.bson.codecs.pojo.annotations.BsonRepresentation;

final class ConventionAnnotationImpl
implements Convention {
    ConventionAnnotationImpl() {
    }

    @Override
    public void apply(ClassModelBuilder<?> classModelBuilder) {
        for (Annotation object : classModelBuilder.getAnnotations()) {
            this.processClassAnnotation(classModelBuilder, object);
        }
        for (PropertyModelBuilder propertyModelBuilder : classModelBuilder.getPropertyModelBuilders()) {
            this.processPropertyAnnotations(classModelBuilder, propertyModelBuilder);
        }
        this.processCreatorAnnotation(classModelBuilder);
        this.cleanPropertyBuilders(classModelBuilder);
    }

    private void processClassAnnotation(ClassModelBuilder<?> classModelBuilder, Annotation annotation) {
        if (annotation instanceof BsonDiscriminator) {
            String string;
            BsonDiscriminator bsonDiscriminator = (BsonDiscriminator)annotation;
            String string2 = bsonDiscriminator.key();
            if (!string2.equals("")) {
                classModelBuilder.discriminatorKey(string2);
            }
            if (!(string = bsonDiscriminator.value()).equals("")) {
                classModelBuilder.discriminator(string);
            }
            classModelBuilder.enableDiscriminator(true);
        }
    }

    private void processPropertyAnnotations(ClassModelBuilder<?> classModelBuilder, PropertyModelBuilder<?> propertyModelBuilder) {
        Annotation annotation;
        for (Annotation annotation2 : propertyModelBuilder.getReadAnnotations()) {
            if (annotation2 instanceof BsonProperty) {
                annotation = (BsonProperty)annotation2;
                if (!"".equals(annotation.value())) {
                    propertyModelBuilder.readName(annotation.value());
                }
                propertyModelBuilder.discriminatorEnabled(annotation.useDiscriminator());
                if (!propertyModelBuilder.getName().equals(classModelBuilder.getIdPropertyName())) continue;
                classModelBuilder.idPropertyName(null);
                continue;
            }
            if (annotation2 instanceof BsonId) {
                classModelBuilder.idPropertyName(propertyModelBuilder.getName());
                continue;
            }
            if (annotation2 instanceof BsonIgnore) {
                propertyModelBuilder.readName(null);
                continue;
            }
            if (annotation2 instanceof BsonRepresentation) {
                annotation = (BsonRepresentation)annotation2;
                BsonType bsonType = annotation.value();
                propertyModelBuilder.bsonRepresentation(bsonType);
                continue;
            }
            if (!(annotation2 instanceof BsonExtraElements)) continue;
            this.processBsonExtraElementsAnnotation(propertyModelBuilder);
        }
        for (Annotation annotation2 : propertyModelBuilder.getWriteAnnotations()) {
            if (annotation2 instanceof BsonProperty) {
                annotation = (BsonProperty)annotation2;
                if ("".equals(annotation.value())) continue;
                propertyModelBuilder.writeName(annotation.value());
                continue;
            }
            if (!(annotation2 instanceof BsonIgnore)) continue;
            propertyModelBuilder.writeName(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> void processCreatorAnnotation(ClassModelBuilder<T> classModelBuilder) {
        int n;
        Class clazz = classModelBuilder.getType();
        CreatorExecutable creatorExecutable = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers()) || constructor.isSynthetic()) continue;
            Annotation[] annotationArray = constructor.getDeclaredAnnotations();
            n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation annotation = annotationArray[i];
                if (!annotation.annotationType().equals(BsonCreator.class)) continue;
                if (creatorExecutable != null) {
                    throw new CodecConfigurationException("Found multiple constructors annotated with @BsonCreator");
                }
                creatorExecutable = new CreatorExecutable(clazz, constructor);
            }
        }
        int n2 = 0;
        for (Object object = clazz; object != null && n2 == 0; object = ((Class)object).getSuperclass()) {
            for (Method method : ((Class)object).getDeclaredMethods()) {
                if (!Modifier.isStatic(method.getModifiers()) || method.isSynthetic() || method.isBridge()) continue;
                for (Annotation object2 : method.getDeclaredAnnotations()) {
                    if (!object2.annotationType().equals(BsonCreator.class)) continue;
                    if (creatorExecutable != null) {
                        throw new CodecConfigurationException("Found multiple constructors / methods annotated with @BsonCreator");
                    }
                    if (!((Class)object).isAssignableFrom(method.getReturnType())) {
                        throw new CodecConfigurationException(String.format("Invalid method annotated with @BsonCreator. Returns '%s', expected %s", method.getReturnType(), object));
                    }
                    creatorExecutable = new CreatorExecutable(clazz, method);
                    n2 = 1;
                }
            }
        }
        if (creatorExecutable != null) {
            List<BsonProperty> list = creatorExecutable.getProperties();
            List<Class<?>> list2 = creatorExecutable.getParameterTypes();
            List<Type> list3 = creatorExecutable.getParameterGenericTypes();
            if (list.size() != list2.size()) {
                throw creatorExecutable.getError(clazz, "All parameters in the @BsonCreator method / constructor must be annotated with a @BsonProperty.");
            }
            for (n = 0; n < list.size(); ++n) {
                void var13_37;
                boolean bl = creatorExecutable.getIdPropertyIndex() != null && creatorExecutable.getIdPropertyIndex().equals(n);
                Class<?> clazz2 = list2.get(n);
                Type type = list3.get(n);
                Object var13_28 = null;
                if (bl) {
                    if (classModelBuilder.getIdPropertyName() == null) {
                        throw new CodecConfigurationException("A @BsonId annotation has been used with @BsonCreator but there is no known Id property.\nPlease either use the @BsonProperty annotation in the creator or annotate the corresponding property in the class with the @BsonId.");
                    }
                    PropertyModelBuilder<?> propertyModelBuilder = classModelBuilder.getProperty(classModelBuilder.getIdPropertyName());
                } else {
                    void var13_35;
                    void var13_33;
                    BsonProperty bsonProperty = list.get(n);
                    for (PropertyModelBuilder<?> propertyModelBuilder : classModelBuilder.getPropertyModelBuilders()) {
                        if (bsonProperty.value().equals(propertyModelBuilder.getWriteName())) {
                            PropertyModelBuilder<?> propertyModelBuilder2 = propertyModelBuilder;
                            break;
                        }
                        if (!bsonProperty.value().equals(propertyModelBuilder.getReadName())) continue;
                        PropertyModelBuilder<?> propertyModelBuilder3 = propertyModelBuilder;
                    }
                    if (var13_33 == null) {
                        PropertyModelBuilder<?> propertyModelBuilder = classModelBuilder.getProperty(bsonProperty.value());
                    }
                    if (var13_35 == null) {
                        PropertyModelBuilder<?> propertyModelBuilder = this.addCreatorPropertyToClassModelBuilder(classModelBuilder, bsonProperty.value(), clazz2);
                    } else {
                        if (!bsonProperty.value().equals(var13_35.getName())) {
                            var13_35.writeName(bsonProperty.value());
                        }
                        ConventionAnnotationImpl.tryToExpandToGenericType(clazz2, var13_35, type);
                    }
                }
                if (var13_37.getTypeData().isAssignableFrom(clazz2)) continue;
                throw creatorExecutable.getError(clazz, String.format("Invalid Property type for '%s'. Expected %s, found %s.", var13_37.getWriteName(), var13_37.getTypeData().getType(), clazz2));
            }
            classModelBuilder.instanceCreatorFactory(new InstanceCreatorFactoryImpl(creatorExecutable));
        }
    }

    private static <T> void tryToExpandToGenericType(Class<?> clazz, PropertyModelBuilder<T> propertyModelBuilder, Type type) {
        if (clazz.isAssignableFrom(propertyModelBuilder.getTypeData().getType())) {
            propertyModelBuilder.typeData(TypeData.newInstance(type, clazz));
        }
    }

    private <T, S> PropertyModelBuilder<S> addCreatorPropertyToClassModelBuilder(ClassModelBuilder<T> classModelBuilder, String string, Class<S> clazz) {
        PropertyModelBuilder<S> propertyModelBuilder = PojoBuilderHelper.createPropertyModelBuilder(new PropertyMetadata<S>(string, classModelBuilder.getType().getSimpleName(), TypeData.builder(clazz).build())).readName(null).writeName(string);
        classModelBuilder.addProperty(propertyModelBuilder);
        return propertyModelBuilder;
    }

    private void cleanPropertyBuilders(ClassModelBuilder<?> classModelBuilder) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PropertyModelBuilder<?> propertyModelBuilder : classModelBuilder.getPropertyModelBuilders()) {
            if (propertyModelBuilder.isReadable() || propertyModelBuilder.isWritable()) continue;
            arrayList.add(propertyModelBuilder.getName());
        }
        for (String string : arrayList) {
            classModelBuilder.removeProperty(string);
        }
    }

    private <T> void processBsonExtraElementsAnnotation(PropertyModelBuilder<T> propertyModelBuilder) {
        PropertyAccessor<T> propertyAccessor = propertyModelBuilder.getPropertyAccessor();
        if (!(propertyAccessor instanceof PropertyAccessorImpl)) {
            throw new CodecConfigurationException(String.format("The @BsonExtraElements annotation is not compatible with propertyModelBuilder instances that have custom implementations of org.bson.codecs.pojo.PropertyAccessor: %s", propertyModelBuilder.getPropertyAccessor().getClass().getName()));
        }
        if (!Map.class.isAssignableFrom(propertyModelBuilder.getTypeData().getType())) {
            throw new CodecConfigurationException(String.format("The @BsonExtraElements annotation is not compatible with propertyModelBuilder with the following type: %s. Please use a Document, BsonDocument or Map<String, Object> type.", propertyModelBuilder.getTypeData()));
        }
        propertyModelBuilder.propertySerialization(new PropertyModelSerializationInlineImpl<T>(propertyModelBuilder.getPropertySerialization()));
        propertyModelBuilder.propertyAccessor(new FieldPropertyAccessor((PropertyAccessorImpl)propertyAccessor));
    }
}

