/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.Collection;
import java.util.Map;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.ClassModelBuilder;
import org.bson.codecs.pojo.Convention;
import org.bson.codecs.pojo.PropertyAccessor;
import org.bson.codecs.pojo.PropertyAccessorImpl;
import org.bson.codecs.pojo.PropertyMetadata;
import org.bson.codecs.pojo.PropertyModelBuilder;

final class ConventionUseGettersAsSettersImpl
implements Convention {
    ConventionUseGettersAsSettersImpl() {
    }

    @Override
    public void apply(ClassModelBuilder<?> classModelBuilder) {
        for (PropertyModelBuilder<?> propertyModelBuilder : classModelBuilder.getPropertyModelBuilders()) {
            if (!(propertyModelBuilder.getPropertyAccessor() instanceof PropertyAccessorImpl)) {
                throw new CodecConfigurationException(String.format("The USE_GETTER_AS_SETTER_CONVENTION is not compatible with propertyModelBuilder instance that have custom implementations of org.bson.codecs.pojo.PropertyAccessor: %s", propertyModelBuilder.getPropertyAccessor().getClass().getName()));
            }
            PropertyAccessorImpl propertyAccessorImpl = (PropertyAccessorImpl)propertyModelBuilder.getPropertyAccessor();
            PropertyMetadata propertyMetadata = propertyAccessorImpl.getPropertyMetadata();
            if (propertyMetadata.isDeserializable() || !propertyMetadata.isSerializable() || !this.isMapOrCollection(propertyMetadata.getTypeData().getType())) continue;
            this.setPropertyAccessor(propertyModelBuilder);
        }
    }

    private <T> boolean isMapOrCollection(Class<T> clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    private <T> void setPropertyAccessor(PropertyModelBuilder<T> propertyModelBuilder) {
        propertyModelBuilder.propertyAccessor(new PrivatePropertyAccessor((PropertyAccessorImpl)propertyModelBuilder.getPropertyAccessor()));
    }

    private static final class PrivatePropertyAccessor<T>
    implements PropertyAccessor<T> {
        private final PropertyAccessorImpl<T> wrapped;

        private PrivatePropertyAccessor(PropertyAccessorImpl<T> propertyAccessorImpl) {
            this.wrapped = propertyAccessorImpl;
        }

        @Override
        public <S> T get(S s) {
            return this.wrapped.get(s);
        }

        @Override
        public <S> void set(S s, T t) {
            if (t instanceof Collection) {
                this.mutateCollection(s, (Collection)t);
            } else if (t instanceof Map) {
                this.mutateMap(s, (Map)t);
            } else {
                this.throwCodecConfigurationException(String.format("Unexpected type: '%s'", t.getClass()), null);
            }
        }

        private <S> void mutateCollection(S s, Collection collection) {
            T t = this.get(s);
            Collection collection2 = (Collection)t;
            if (collection2 == null) {
                this.throwCodecConfigurationException("The getter returned null.", null);
            } else if (!collection2.isEmpty()) {
                this.throwCodecConfigurationException("The getter returned a non empty collection.", null);
            } else {
                try {
                    collection2.addAll(collection);
                }
                catch (Exception exception) {
                    this.throwCodecConfigurationException("collection#addAll failed.", exception);
                }
            }
        }

        private <S> void mutateMap(S s, Map map) {
            T t = this.get(s);
            Map map2 = (Map)t;
            if (map2 == null) {
                this.throwCodecConfigurationException("The getter returned null.", null);
            } else if (!map2.isEmpty()) {
                this.throwCodecConfigurationException("The getter returned a non empty map.", null);
            } else {
                try {
                    map2.putAll(map);
                }
                catch (Exception exception) {
                    this.throwCodecConfigurationException("map#putAll failed.", exception);
                }
            }
        }

        private void throwCodecConfigurationException(String string, Exception exception) {
            throw new CodecConfigurationException(String.format("Cannot use getter in '%s' to set '%s'. %s", this.wrapped.getPropertyMetadata().getDeclaringClassName(), this.wrapped.getPropertyMetadata().getName(), string), exception);
        }
    }
}

