/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.annotations.BsonId;
import org.bson.codecs.pojo.annotations.BsonProperty;

final class CreatorExecutable<T> {
    private final Class<T> clazz;
    private final Constructor<T> constructor;
    private final Method method;
    private final List<BsonProperty> properties = new ArrayList<BsonProperty>();
    private final Integer idPropertyIndex;
    private final List<Class<?>> parameterTypes = new ArrayList();
    private final List<Type> parameterGenericTypes = new ArrayList<Type>();

    CreatorExecutable(Class<T> clazz, Constructor<T> constructor) {
        this(clazz, constructor, null);
    }

    CreatorExecutable(Class<T> clazz, Method method) {
        this(clazz, null, method);
    }

    private CreatorExecutable(Class<T> clazz, Constructor<T> constructor, Method method) {
        this.clazz = clazz;
        this.constructor = constructor;
        this.method = method;
        Integer n = null;
        if (constructor != null || method != null) {
            Class<?>[] classArray = constructor != null ? constructor.getParameterTypes() : method.getParameterTypes();
            Type[] typeArray = constructor != null ? constructor.getGenericParameterTypes() : method.getGenericParameterTypes();
            this.parameterTypes.addAll(Arrays.asList(classArray));
            this.parameterGenericTypes.addAll(Arrays.asList(typeArray));
            Annotation[][] annotationArray = constructor != null ? constructor.getParameterAnnotations() : method.getParameterAnnotations();
            block0: for (int i = 0; i < annotationArray.length; ++i) {
                Annotation[] annotationArray2;
                for (Annotation annotation : annotationArray2 = annotationArray[i]) {
                    if (annotation.annotationType().equals(BsonProperty.class)) {
                        this.properties.add((BsonProperty)annotation);
                        continue block0;
                    }
                    if (!annotation.annotationType().equals(BsonId.class)) continue;
                    this.properties.add(null);
                    n = i;
                    continue block0;
                }
            }
        }
        this.idPropertyIndex = n;
    }

    Class<T> getType() {
        return this.clazz;
    }

    List<BsonProperty> getProperties() {
        return this.properties;
    }

    Integer getIdPropertyIndex() {
        return this.idPropertyIndex;
    }

    List<Class<?>> getParameterTypes() {
        return this.parameterTypes;
    }

    List<Type> getParameterGenericTypes() {
        return this.parameterGenericTypes;
    }

    T getInstance() {
        this.checkHasAnExecutable();
        try {
            if (this.constructor != null) {
                return this.constructor.newInstance(new Object[0]);
            }
            return (T)this.method.invoke(this.clazz, new Object[0]);
        }
        catch (Exception exception) {
            throw new CodecConfigurationException(exception.getMessage(), exception);
        }
    }

    T getInstance(Object[] objectArray) {
        this.checkHasAnExecutable();
        try {
            if (this.constructor != null) {
                return this.constructor.newInstance(objectArray);
            }
            return (T)this.method.invoke(this.clazz, objectArray);
        }
        catch (Exception exception) {
            throw new CodecConfigurationException(exception.getMessage(), exception);
        }
    }

    CodecConfigurationException getError(Class<?> clazz, String string) {
        return CreatorExecutable.getError(clazz, this.constructor != null, string);
    }

    private void checkHasAnExecutable() {
        if (this.constructor == null && this.method == null) {
            throw new CodecConfigurationException(String.format("Cannot find a public constructor for '%s'.  Please ensure the class has a public, empty constructor with no arguments, or else a constructor with a BsonCreator annotation", this.clazz.getSimpleName()));
        }
    }

    private static CodecConfigurationException getError(Class<?> clazz, boolean bl, String string) {
        return new CodecConfigurationException(String.format("Invalid @BsonCreator %s in %s. %s", bl ? "constructor" : "method", clazz.getSimpleName(), string));
    }
}

