/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.ClassModel;

final class DiscriminatorLookup {
    private final Map<String, Class<?>> discriminatorClassMap = new ConcurrentHashMap();
    private final Set<String> packages;

    DiscriminatorLookup(Map<Class<?>, ClassModel<?>> map, Set<String> set) {
        for (ClassModel<?> classModel : map.values()) {
            if (classModel.getDiscriminator() == null) continue;
            this.discriminatorClassMap.put(classModel.getDiscriminator(), classModel.getType());
        }
        this.packages = set;
    }

    public Class<?> lookup(String string) {
        if (this.discriminatorClassMap.containsKey(string)) {
            return this.discriminatorClassMap.get(string);
        }
        Class<?> clazz = this.getClassForName(string);
        if (clazz == null) {
            clazz = this.searchPackages(string);
        }
        if (clazz == null) {
            throw new CodecConfigurationException(String.format("A class could not be found for the discriminator: '%s'.", string));
        }
        this.discriminatorClassMap.put(string, clazz);
        return clazz;
    }

    void addClassModel(ClassModel<?> classModel) {
        if (classModel.getDiscriminator() != null) {
            this.discriminatorClassMap.put(classModel.getDiscriminator(), classModel.getType());
        }
    }

    private Class<?> getClassForName(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    private Class<?> searchPackages(String string) {
        Class<?> clazz = null;
        for (String string2 : this.packages) {
            clazz = this.getClassForName(string2 + "." + string);
            if (clazz == null) continue;
            return clazz;
        }
        return clazz;
    }
}

