/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bson.assertions.Assertions;

final class Either<L, R> {
    private final L left;
    private final R right;

    public static <L, R> Either<L, R> left(L l) {
        return new Either<L, Object>(Assertions.notNull("value", l), null);
    }

    public static <L, R> Either<L, R> right(R r) {
        return new Either<Object, R>(null, Assertions.notNull("value", r));
    }

    private Either(L l, R r) {
        this.left = l;
        this.right = r;
    }

    public <T> T map(Function<? super L, ? extends T> function, Function<? super R, ? extends T> function2) {
        return this.left != null ? function.apply(this.left) : function2.apply(this.right);
    }

    public void apply(Consumer<? super L> consumer, Consumer<? super R> consumer2) {
        if (this.left != null) {
            consumer.accept(this.left);
        }
        if (this.right != null) {
            consumer2.accept(this.right);
        }
    }

    public String toString() {
        return "Either{left=" + this.left + ", right=" + this.right + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Either either = (Either)object;
        return Objects.equals(this.left, either.left) && Objects.equals(this.right, either.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }
}

