/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.PropertyAccessor;
import org.bson.codecs.pojo.PropertyAccessorImpl;

final class FieldPropertyAccessor<T>
implements PropertyAccessor<T> {
    private final PropertyAccessorImpl<T> wrapped;

    FieldPropertyAccessor(PropertyAccessorImpl<T> propertyAccessorImpl) {
        this.wrapped = propertyAccessorImpl;
        try {
            propertyAccessorImpl.getPropertyMetadata().getField().setAccessible(true);
        }
        catch (Exception exception) {
            throw new CodecConfigurationException(String.format("Unable to make field accessible '%s' in %s", propertyAccessorImpl.getPropertyMetadata().getName(), propertyAccessorImpl.getPropertyMetadata().getDeclaringClassName()), exception);
        }
    }

    @Override
    public <S> T get(S s) {
        return this.wrapped.get(s);
    }

    @Override
    public <S> void set(S s, T t) {
        try {
            this.wrapped.getPropertyMetadata().getField().set(s, t);
        }
        catch (Exception exception) {
            throw new CodecConfigurationException(String.format("Unable to set value for property '%s' in %s", this.wrapped.getPropertyMetadata().getName(), this.wrapped.getPropertyMetadata().getDeclaringClassName()), exception);
        }
    }
}

