/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.Objects;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.ClassModel;
import org.bson.codecs.pojo.IdGenerator;
import org.bson.codecs.pojo.PropertyModel;

final class IdPropertyModelHolder<I> {
    private final PropertyModel<I> propertyModel;
    private final IdGenerator<I> idGenerator;

    static <T, I> IdPropertyModelHolder<I> create(ClassModel<T> classModel, PropertyModel<I> propertyModel) {
        return IdPropertyModelHolder.create(classModel.getType(), propertyModel, classModel.getIdPropertyModelHolder().getIdGenerator());
    }

    static <T, I, V> IdPropertyModelHolder<I> create(Class<T> clazz, PropertyModel<I> propertyModel, IdGenerator<V> idGenerator) {
        if (propertyModel == null && idGenerator != null) {
            throw new CodecConfigurationException(String.format("Invalid IdGenerator. There is no IdProperty set for: %s", clazz));
        }
        if (idGenerator != null && !propertyModel.getTypeData().getType().isAssignableFrom(idGenerator.getType())) {
            throw new CodecConfigurationException(String.format("Invalid IdGenerator. Mismatching types, the IdProperty type is: %s but the IdGenerator type is: %s", propertyModel.getTypeData().getType(), idGenerator.getType()));
        }
        return new IdPropertyModelHolder<I>(propertyModel, idGenerator);
    }

    private IdPropertyModelHolder(PropertyModel<I> propertyModel, IdGenerator<I> idGenerator) {
        this.propertyModel = propertyModel;
        this.idGenerator = idGenerator;
    }

    PropertyModel<I> getPropertyModel() {
        return this.propertyModel;
    }

    IdGenerator<I> getIdGenerator() {
        return this.idGenerator;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IdPropertyModelHolder idPropertyModelHolder = (IdPropertyModelHolder)object;
        if (!Objects.equals(this.propertyModel, idPropertyModelHolder.propertyModel)) {
            return false;
        }
        return Objects.equals(this.idGenerator, idPropertyModelHolder.idGenerator);
    }

    public int hashCode() {
        int n = this.propertyModel != null ? this.propertyModel.hashCode() : 0;
        n = 31 * n + (this.idGenerator != null ? this.idGenerator.hashCode() : 0);
        return n;
    }
}

