/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.RepresentationConfigurable;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.ClassModel;
import org.bson.codecs.pojo.DiscriminatorLookup;
import org.bson.codecs.pojo.IdPropertyModelHolder;
import org.bson.codecs.pojo.LazyMissingCodec;
import org.bson.codecs.pojo.PojoCodec;
import org.bson.codecs.pojo.PojoCodecImpl;
import org.bson.codecs.pojo.PojoSpecializationHelper;
import org.bson.codecs.pojo.PropertyCodecRegistry;
import org.bson.codecs.pojo.PropertyModel;
import org.bson.codecs.pojo.TypeData;
import org.bson.codecs.pojo.TypeParameterMap;

class LazyPropertyModelCodec<T>
implements Codec<T> {
    private final PropertyModel<T> propertyModel;
    private final CodecRegistry registry;
    private final PropertyCodecRegistry propertyCodecRegistry;
    private final Lock codecLock = new ReentrantLock();
    private volatile Codec<T> codec;

    LazyPropertyModelCodec(PropertyModel<T> propertyModel, CodecRegistry codecRegistry, PropertyCodecRegistry propertyCodecRegistry) {
        this.propertyModel = propertyModel;
        this.registry = codecRegistry;
        this.propertyCodecRegistry = propertyCodecRegistry;
    }

    @Override
    public T decode(BsonReader bsonReader, DecoderContext decoderContext) {
        return this.getPropertyModelCodec().decode(bsonReader, decoderContext);
    }

    @Override
    public void encode(BsonWriter bsonWriter, T t, EncoderContext encoderContext) {
        this.getPropertyModelCodec().encode(bsonWriter, t, encoderContext);
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.propertyModel.getTypeData().getType();
    }

    private Codec<T> getPropertyModelCodec() {
        Codec<T> codec = this.codec;
        if (codec == null) {
            this.codecLock.lock();
            try {
                codec = this.codec;
                if (codec == null) {
                    this.codec = codec = this.createCodec();
                }
            }
            finally {
                this.codecLock.unlock();
            }
        }
        return codec;
    }

    private Codec<T> createCodec() {
        Codec<T> codec = this.getCodecFromPropertyRegistry(this.propertyModel);
        if (codec instanceof PojoCodec) {
            PojoCodec pojoCodec = (PojoCodec)codec;
            ClassModel classModel = this.getSpecializedClassModel(pojoCodec.getClassModel(), this.propertyModel);
            codec = new PojoCodecImpl(classModel, this.registry, this.propertyCodecRegistry, pojoCodec.getDiscriminatorLookup());
        }
        return codec;
    }

    private Codec<T> getCodecFromPropertyRegistry(PropertyModel<T> propertyModel) {
        BsonType bsonType;
        Codec<T> codec;
        try {
            codec = this.propertyCodecRegistry.get(propertyModel.getTypeData());
        }
        catch (CodecConfigurationException codecConfigurationException) {
            return new LazyMissingCodec<T>(propertyModel.getTypeData().getType(), codecConfigurationException);
        }
        if (codec == null) {
            codec = new LazyMissingCodec<T>(propertyModel.getTypeData().getType(), new CodecConfigurationException("Unexpected missing codec for: " + propertyModel.getName()));
        }
        if ((bsonType = propertyModel.getBsonRepresentation()) != null) {
            if (codec instanceof RepresentationConfigurable) {
                return ((RepresentationConfigurable)((Object)codec)).withRepresentation(bsonType);
            }
            throw new CodecConfigurationException("Codec must implement RepresentationConfigurable to support BsonRepresentation");
        }
        return codec;
    }

    private <V> ClassModel<T> getSpecializedClassModel(ClassModel<T> classModel, PropertyModel<V> propertyModel) {
        int n;
        boolean bl;
        boolean bl2 = propertyModel.useDiscriminator() == null ? classModel.useDiscriminator() : propertyModel.useDiscriminator().booleanValue();
        boolean bl3 = classModel.getDiscriminatorKey() != null && classModel.getDiscriminator() != null;
        boolean bl4 = bl = bl2 != classModel.useDiscriminator() && bl3;
        if (propertyModel.getTypeData().getTypeParameters().isEmpty() && !bl) {
            return classModel;
        }
        ArrayList arrayList = new ArrayList(classModel.getPropertyModels());
        PropertyModel<?> propertyModel2 = classModel.getIdPropertyModel();
        List<TypeData<?>> list = propertyModel.getTypeData().getTypeParameters();
        for (n = 0; n < arrayList.size(); ++n) {
            PropertyModel<?> propertyModel3 = arrayList.get(n);
            String string = propertyModel3.getName();
            TypeParameterMap typeParameterMap = classModel.getPropertyNameToTypeParameterMap().get(string);
            if (!typeParameterMap.hasTypeParameters()) continue;
            PropertyModel<?> propertyModel4 = this.getSpecializedPropertyModel(propertyModel3, list, typeParameterMap);
            arrayList.set(n, propertyModel4);
            if (propertyModel2 == null || !propertyModel2.getName().equals(string)) continue;
            propertyModel2 = propertyModel4;
        }
        n = (bl ? propertyModel.useDiscriminator().booleanValue() : classModel.useDiscriminator()) ? 1 : 0;
        return new ClassModel<T>(classModel.getType(), classModel.getPropertyNameToTypeParameterMap(), classModel.getInstanceCreatorFactory(), n != 0, classModel.getDiscriminatorKey(), classModel.getDiscriminator(), IdPropertyModelHolder.create(classModel, propertyModel2), arrayList);
    }

    private <V> PropertyModel<V> getSpecializedPropertyModel(PropertyModel<V> propertyModel, List<TypeData<?>> list, TypeParameterMap typeParameterMap) {
        TypeData<V> typeData = PojoSpecializationHelper.specializeTypeData(propertyModel.getTypeData(), list, typeParameterMap);
        if (propertyModel.getTypeData().equals(typeData)) {
            return propertyModel;
        }
        return new PropertyModel<V>(propertyModel.getName(), propertyModel.getReadName(), propertyModel.getWriteName(), typeData, null, propertyModel.getPropertySerialization(), propertyModel.useDiscriminator(), propertyModel.getPropertyAccessor(), propertyModel.getError(), propertyModel.getBsonRepresentation());
    }

    static final class NeedSpecializationCodec<T>
    extends PojoCodec<T> {
        private final ClassModel<T> classModel;
        private final DiscriminatorLookup discriminatorLookup;
        private final CodecRegistry codecRegistry;

        NeedSpecializationCodec(ClassModel<T> classModel, DiscriminatorLookup discriminatorLookup, CodecRegistry codecRegistry) {
            this.classModel = classModel;
            this.discriminatorLookup = discriminatorLookup;
            this.codecRegistry = codecRegistry;
        }

        @Override
        public void encode(BsonWriter bsonWriter, T t, EncoderContext encoderContext) {
            if (t.getClass().equals(this.classModel.getType())) {
                throw this.exception();
            }
            this.tryEncode(this.codecRegistry.get(t.getClass()), bsonWriter, t, encoderContext);
        }

        @Override
        public T decode(BsonReader bsonReader, DecoderContext decoderContext) {
            return this.tryDecode(bsonReader, decoderContext);
        }

        private <A> void tryEncode(Codec<A> codec, BsonWriter bsonWriter, T t, EncoderContext encoderContext) {
            try {
                codec.encode(bsonWriter, t, encoderContext);
            }
            catch (Exception exception) {
                throw this.exception();
            }
        }

        public T tryDecode(BsonReader bsonReader, DecoderContext decoderContext) {
            Codec codec = PojoCodecImpl.getCodecFromDocument(bsonReader, this.classModel.useDiscriminator(), this.classModel.getDiscriminatorKey(), this.codecRegistry, this.discriminatorLookup, null, this.classModel.getName());
            if (codec != null) {
                return codec.decode(bsonReader, decoderContext);
            }
            throw this.exception();
        }

        @Override
        public Class<T> getEncoderClass() {
            return this.classModel.getType();
        }

        private CodecConfigurationException exception() {
            return new CodecConfigurationException(String.format("%s contains generic types that have not been specialised.%nTop level classes with generic types are not supported by the PojoCodec.", this.classModel.getName()));
        }

        @Override
        ClassModel<T> getClassModel() {
            return this.classModel;
        }

        @Override
        DiscriminatorLookup getDiscriminatorLookup() {
            return this.discriminatorLookup;
        }
    }
}

